/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.testsupport.internal;

import com.orientechnologies.common.io.OFileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.sonatype.nexus.common.io.DirectoryHelper;
import org.sonatype.nexus.orient.DatabaseManagerSupport;

public class PersistentDatabaseManager
extends DatabaseManagerSupport {
    private static final Path BASEDIR = new File(System.getProperty("basedir", "")).toPath();
    private final File databasesDirectory = Files.createTempDirectory(BASEDIR.resolve("target"), "test-db.", new FileAttribute[0]).toFile();

    public PersistentDatabaseManager() throws IOException {
        this.log.info("Database dir: {}", (Object)this.databasesDirectory);
    }

    private File directory(String name) throws IOException {
        return new File(this.databasesDirectory, name).getCanonicalFile();
    }

    @Override
    protected String connectionUri(String name) {
        try {
            File dir = this.directory(name);
            DirectoryHelper.mkdir(dir);
            return "plocal:" + OFileUtils.getPath(dir.getAbsolutePath()).replace("//", "/");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

