/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.authc.apikey;

import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.security.authc.apikey.ApiKey;

public interface ApiKeyStore
extends Lifecycle {
    public char[] createApiKey(String var1, PrincipalCollection var2);

    default public void persistApiKey(String domain, PrincipalCollection principals, char[] apiKey) {
        this.persistApiKey(domain, principals, apiKey, null);
    }

    public void persistApiKey(String var1, PrincipalCollection var2, char[] var3, @Nullable OffsetDateTime var4);

    public Optional<ApiKey> getApiKey(String var1, PrincipalCollection var2);

    public Optional<ApiKey> getApiKeyByToken(String var1, char[] var2);

    public Collection<ApiKey> browse(String var1);

    public Collection<ApiKey> browseByCreatedDate(String var1, OffsetDateTime var2);

    public Collection<ApiKey> browsePaginated(String var1, int var2, int var3);

    public int count(String var1);

    public void deleteApiKey(String var1, PrincipalCollection var2);

    public void deleteApiKeys(PrincipalCollection var1);

    public void deleteApiKeys();

    public void deleteApiKeys(String var1);

    public void purgeApiKeys();

    public void deleteApiKeys(OffsetDateTime var1);

    public void updateApiKey(ApiKey var1, ApiKey var2);

    default public ApiKey newApiKey(String domain, PrincipalCollection principals, char[] apiKey) {
        return this.newApiKey(domain, principals, apiKey, OffsetDateTime.now());
    }

    public ApiKey newApiKey(String var1, PrincipalCollection var2, char[] var3, OffsetDateTime var4);
}

