/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.token;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKey;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;

public abstract class BearerTokenManager
extends ComponentSupport {
    protected final ApiKeyStore apiKeyStore;
    protected final SecurityHelper securityHelper;
    private final String format;

    @Inject
    public BearerTokenManager(ApiKeyStore apiKeyStore, SecurityHelper securityHelper, String format) {
        this.apiKeyStore = Preconditions.checkNotNull(apiKeyStore);
        this.securityHelper = Preconditions.checkNotNull(securityHelper);
        this.format = Preconditions.checkNotNull(format);
    }

    protected String createToken(PrincipalCollection principals) {
        Preconditions.checkNotNull(principals);
        char[] apiKey = this.apiKeyStore.getApiKey(this.format, principals).map(ApiKey::getApiKey).orElse(null);
        if (apiKey != null) {
            return String.valueOf(this.format) + "." + new String(apiKey);
        }
        return String.valueOf(this.format) + "." + new String(this.apiKeyStore.createApiKey(this.format, principals));
    }

    public boolean deleteToken() {
        PrincipalCollection principals = this.securityHelper.subject().getPrincipals();
        if (this.apiKeyStore.getApiKey(this.format, principals).isPresent()) {
            this.apiKeyStore.deleteApiKey(this.format, this.securityHelper.subject().getPrincipals());
            return true;
        }
        return false;
    }
}

