/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.token;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.authc.NexusApiKeyAuthenticationToken;
import org.sonatype.nexus.security.authc.apikey.ApiKey;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.user.UserNotFoundException;

public abstract class BearerTokenRealm
extends AuthenticatingRealm {
    public static final String IS_TOKEN_AUTH_KEY = String.valueOf(BearerTokenRealm.class.getName()) + ".IS_TOKEN";
    @VisibleForTesting
    static final String ANONYMOUS_USER = "anonymous";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ApiKeyStore keyStore;
    private final UserPrincipalsHelper principalsHelper;
    private final String format;
    private Provider<HttpServletRequest> requestProvider;

    protected BearerTokenRealm(ApiKeyStore keyStore, UserPrincipalsHelper principalsHelper, String format) {
        this.keyStore = Preconditions.checkNotNull(keyStore);
        this.principalsHelper = Preconditions.checkNotNull(principalsHelper);
        this.format = Preconditions.checkNotNull(format);
        this.setName(format);
        this.setAuthenticationCachingEnabled(true);
    }

    @Inject
    protected void setRequestProvider(Provider<HttpServletRequest> requestProvider) {
        this.requestProvider = Preconditions.checkNotNull(requestProvider);
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof NexusApiKeyAuthenticationToken && this.format.equals(token.getPrincipal());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) {
        Preconditions.checkNotNull(token);
        return this.getPrincipals(token).map(principals -> {
            try {
                if (this.anonymousAndSupported((PrincipalCollection)principals) || this.principalsHelper.getUserStatus((PrincipalCollection)principals).isActive()) {
                    return new SimpleAuthenticationInfo(principals, token.getCredentials());
                }
            }
            catch (UserNotFoundException e) {
                this.log.debug("Realm did not find user", e);
                this.keyStore.deleteApiKeys((PrincipalCollection)principals);
            }
            return null;
        }).orElse(null);
    }

    @Nullable
    protected Object getAuthenticationCacheKey(@Nullable AuthenticationToken token) {
        if (token != null) {
            return this.getPrincipals(token).map(PrincipalCollection::getPrimaryPrincipal).orElse(null);
        }
        return null;
    }

    protected void assertCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) throws AuthenticationException {
        super.assertCredentialsMatch(token, info);
        this.requestProvider.get().setAttribute(IS_TOKEN_AUTH_KEY, (Object)Boolean.TRUE);
        this.getPrincipals(token).map(PrincipalCollection::getPrimaryPrincipal).ifPresent(principal -> ((NexusApiKeyAuthenticationToken)token).setPrincipal(principal));
    }

    protected boolean isAnonymousSupported() {
        return false;
    }

    private Optional<PrincipalCollection> getPrincipals(AuthenticationToken token) {
        return this.keyStore.getApiKeyByToken(this.format, (char[])token.getCredentials()).map(ApiKey::getPrincipals);
    }

    private boolean anonymousAndSupported(PrincipalCollection principals) {
        return ANONYMOUS_USER.equals(principals.getPrimaryPrincipal()) && this.isAnonymousSupported();
    }
}

