/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.batch.core.configuration.support.JobLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class AutomaticJobRegistrar
implements Ordered,
SmartLifecycle,
ApplicationContextAware,
InitializingBean {
    private Collection<ApplicationContextFactory> applicationContextFactories = new ArrayList<ApplicationContextFactory>();
    private JobLoader jobLoader;
    private ApplicationContext applicationContext;
    private volatile boolean running = false;
    private int phase = -2147482648;
    private boolean autoStartup = true;
    private Object lifecycleMonitor = new Object();
    private int order = Integer.MAX_VALUE;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void addApplicationContextFactory(ApplicationContextFactory applicationContextFactory) {
        if (applicationContextFactory instanceof ApplicationContextAware) {
            ((ApplicationContextAware)((Object)applicationContextFactory)).setApplicationContext(this.applicationContext);
        }
        this.applicationContextFactories.add(applicationContextFactory);
    }

    public void setApplicationContextFactories(ApplicationContextFactory[] applicationContextFactories) {
        for (ApplicationContextFactory applicationContextFactory : applicationContextFactories) {
            this.applicationContextFactories.add(applicationContextFactory);
        }
    }

    public void setJobLoader(JobLoader jobLoader) {
        this.jobLoader = jobLoader;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.state(this.jobLoader != null, "A JobLoader must be provided");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.jobLoader.clear();
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                return;
            }
            for (ApplicationContextFactory factory : this.applicationContextFactories) {
                try {
                    this.jobLoader.load(factory);
                }
                catch (DuplicateJobException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    @Override
    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    @Override
    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

