/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.StepHandler;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SimpleStepHandler
implements StepHandler,
InitializingBean {
    private static final Log logger = LogFactory.getLog(SimpleStepHandler.class);
    private JobRepository jobRepository;
    private ExecutionContext executionContext;

    public SimpleStepHandler() {
        this(null);
    }

    public SimpleStepHandler(JobRepository jobRepository) {
        this(jobRepository, new ExecutionContext());
    }

    public SimpleStepHandler(JobRepository jobRepository, ExecutionContext executionContext) {
        this.jobRepository = jobRepository;
        this.executionContext = executionContext;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.jobRepository != null, "A JobRepository must be provided");
    }

    protected JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public StepExecution handleStep(Step step, JobExecution execution) throws JobInterruptedException, JobRestartException, StartLimitExceededException {
        if (execution.isStopping()) {
            throw new JobInterruptedException("JobExecution interrupted.");
        }
        JobInstance jobInstance = execution.getJobInstance();
        StepExecution lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, step.getName());
        if (this.stepExecutionPartOfExistingJobExecution(execution, lastStepExecution)) {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Duplicate step [%s] detected in execution of job=[%s]. If either step fails, both will be executed again on restart.", step.getName(), jobInstance.getJobName()));
            }
            lastStepExecution = null;
        }
        StepExecution currentStepExecution = lastStepExecution;
        if (this.shouldStart(lastStepExecution, execution, step)) {
            boolean isRestart;
            currentStepExecution = execution.createStepExecution(step.getName());
            boolean bl = isRestart = lastStepExecution != null && !lastStepExecution.getStatus().equals((Object)BatchStatus.COMPLETED);
            if (isRestart) {
                currentStepExecution.setExecutionContext(lastStepExecution.getExecutionContext());
                if (lastStepExecution.getExecutionContext().containsKey("batch.executed")) {
                    currentStepExecution.getExecutionContext().remove("batch.executed");
                }
            } else {
                currentStepExecution.setExecutionContext(new ExecutionContext(this.executionContext));
            }
            this.jobRepository.add(currentStepExecution);
            if (logger.isInfoEnabled()) {
                logger.info("Executing step: [" + step.getName() + "]");
            }
            try {
                step.execute(currentStepExecution);
                currentStepExecution.getExecutionContext().put("batch.executed", true);
            }
            catch (JobInterruptedException e) {
                execution.setStatus(BatchStatus.STOPPING);
                throw e;
            }
            this.jobRepository.updateExecutionContext(execution);
            if (currentStepExecution.getStatus() == BatchStatus.STOPPING || currentStepExecution.getStatus() == BatchStatus.STOPPED) {
                execution.setStatus(BatchStatus.STOPPING);
                throw new JobInterruptedException("Job interrupted by step execution");
            }
        }
        return currentStepExecution;
    }

    private boolean stepExecutionPartOfExistingJobExecution(JobExecution jobExecution, StepExecution stepExecution) {
        return stepExecution != null && stepExecution.getJobExecutionId() != null && stepExecution.getJobExecutionId().equals(jobExecution.getId());
    }

    protected boolean shouldStart(StepExecution lastStepExecution, JobExecution jobExecution, Step step) throws JobRestartException, StartLimitExceededException {
        BatchStatus stepStatus = lastStepExecution == null ? BatchStatus.STARTING : lastStepExecution.getStatus();
        if (stepStatus == BatchStatus.UNKNOWN) {
            throw new JobRestartException("Cannot restart step from UNKNOWN status. The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed. Manual intervention is probably necessary.");
        }
        if (stepStatus == BatchStatus.COMPLETED && !step.isAllowStartIfComplete() || stepStatus == BatchStatus.ABANDONED) {
            if (logger.isInfoEnabled()) {
                logger.info("Step already complete or not restartable, so no action to execute: " + lastStepExecution);
            }
            return false;
        }
        if (this.jobRepository.getStepExecutionCount(jobExecution.getJobInstance(), step.getName()) < step.getStartLimit()) {
            return true;
        }
        throw new StartLimitExceededException("Maximum start limit exceeded for step: " + step.getName() + "StartMax: " + step.getStartLimit());
    }
}

