/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.batch.core.annotation.AfterJob;
import org.springframework.batch.core.annotation.BeforeJob;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.listener.JobListenerFactoryBean;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.support.ReflectionUtils;

public abstract class JobBuilderHelper<B extends JobBuilderHelper<B>> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final CommonJobProperties properties;

    public JobBuilderHelper(String name) {
        this.properties = new CommonJobProperties();
        this.properties.name = name;
    }

    protected JobBuilderHelper(JobBuilderHelper<?> parent) {
        this.properties = new CommonJobProperties(parent.properties);
    }

    public B validator(JobParametersValidator jobParametersValidator) {
        this.properties.jobParametersValidator = jobParametersValidator;
        JobBuilderHelper result = this;
        return (B)result;
    }

    public B incrementer(JobParametersIncrementer jobParametersIncrementer) {
        this.properties.jobParametersIncrementer = jobParametersIncrementer;
        JobBuilderHelper result = this;
        return (B)result;
    }

    public B repository(JobRepository jobRepository) {
        this.properties.jobRepository = jobRepository;
        JobBuilderHelper result = this;
        return (B)result;
    }

    public B listener(Object listener) {
        HashSet<Method> jobExecutionListenerMethods = new HashSet<Method>();
        jobExecutionListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), BeforeJob.class));
        jobExecutionListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), AfterJob.class));
        if (jobExecutionListenerMethods.size() > 0) {
            JobListenerFactoryBean factory = new JobListenerFactoryBean();
            factory.setDelegate(listener);
            this.properties.addJobExecutionListener((JobExecutionListener)factory.getObject());
        }
        JobBuilderHelper result = this;
        return (B)result;
    }

    public B listener(JobExecutionListener listener) {
        this.properties.addJobExecutionListener(listener);
        JobBuilderHelper result = this;
        return (B)result;
    }

    public B preventRestart() {
        this.properties.restartable = false;
        JobBuilderHelper result = this;
        return (B)result;
    }

    protected String getName() {
        return this.properties.name;
    }

    protected JobRepository getJobRepository() {
        return this.properties.jobRepository;
    }

    protected boolean isRestartable() {
        return this.properties.restartable;
    }

    protected void enhance(Job target) {
        if (target instanceof AbstractJob) {
            List<JobExecutionListener> listeners;
            Boolean restartable;
            JobParametersValidator jobParametersValidator;
            AbstractJob job = (AbstractJob)target;
            job.setJobRepository(this.properties.getJobRepository());
            JobParametersIncrementer jobParametersIncrementer = this.properties.getJobParametersIncrementer();
            if (jobParametersIncrementer != null) {
                job.setJobParametersIncrementer(jobParametersIncrementer);
            }
            if ((jobParametersValidator = this.properties.getJobParametersValidator()) != null) {
                job.setJobParametersValidator(jobParametersValidator);
            }
            if ((restartable = Boolean.valueOf(this.properties.getRestartable())) != null) {
                job.setRestartable(restartable);
            }
            if (!(listeners = this.properties.getJobExecutionListeners()).isEmpty()) {
                job.setJobExecutionListeners(listeners.toArray(new JobExecutionListener[0]));
            }
        }
    }

    public static class CommonJobProperties {
        private Set<JobExecutionListener> jobExecutionListeners = new LinkedHashSet<JobExecutionListener>();
        private boolean restartable = true;
        private JobRepository jobRepository;
        private JobParametersIncrementer jobParametersIncrementer;
        private JobParametersValidator jobParametersValidator;
        private String name;

        public CommonJobProperties() {
        }

        public CommonJobProperties(CommonJobProperties properties) {
            this.name = properties.name;
            this.restartable = properties.restartable;
            this.jobRepository = properties.jobRepository;
            this.jobExecutionListeners = new LinkedHashSet<JobExecutionListener>(properties.jobExecutionListeners);
            this.jobParametersIncrementer = properties.jobParametersIncrementer;
            this.jobParametersValidator = properties.jobParametersValidator;
        }

        public JobParametersIncrementer getJobParametersIncrementer() {
            return this.jobParametersIncrementer;
        }

        public void setJobParametersIncrementer(JobParametersIncrementer jobParametersIncrementer) {
            this.jobParametersIncrementer = jobParametersIncrementer;
        }

        public JobParametersValidator getJobParametersValidator() {
            return this.jobParametersValidator;
        }

        public void setJobParametersValidator(JobParametersValidator jobParametersValidator) {
            this.jobParametersValidator = jobParametersValidator;
        }

        public JobRepository getJobRepository() {
            return this.jobRepository;
        }

        public void setJobRepository(JobRepository jobRepository) {
            this.jobRepository = jobRepository;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<JobExecutionListener> getJobExecutionListeners() {
            return new ArrayList<JobExecutionListener>(this.jobExecutionListeners);
        }

        public void addStepExecutionListeners(List<JobExecutionListener> jobExecutionListeners) {
            this.jobExecutionListeners.addAll(jobExecutionListeners);
        }

        public void addJobExecutionListener(JobExecutionListener jobExecutionListener) {
            this.jobExecutionListeners.add(jobExecutionListener);
        }

        public boolean getRestartable() {
            return this.restartable;
        }

        public void setRestartable(boolean restartable) {
            this.restartable = restartable;
        }
    }
}

