/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.context.StepContext;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.jsr.SimpleMetric;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JsrStepContext
implements StepContext {
    private static final String PERSISTENT_USER_DATA_KEY = "batch_jsr_persistentUserData";
    private StepExecution stepExecution;
    private Object transientUserData;
    private Properties properties = new Properties();
    private AtomicBoolean exitStatusSet = new AtomicBoolean();
    private final ExecutionContextUserSupport executionContextUserSupport = new ExecutionContextUserSupport(ClassUtils.getShortName(JsrStepContext.class));

    public JsrStepContext(StepExecution stepExecution, Properties properties) {
        Assert.notNull((Object)stepExecution, "A StepExecution is required");
        this.stepExecution = stepExecution;
        this.properties = properties;
    }

    @Override
    public String getStepName() {
        return this.stepExecution.getStepName();
    }

    @Override
    public Object getTransientUserData() {
        return this.transientUserData;
    }

    @Override
    public void setTransientUserData(Object data) {
        this.transientUserData = data;
    }

    @Override
    public long getStepExecutionId() {
        return this.stepExecution.getId();
    }

    @Override
    public Properties getProperties() {
        return this.properties != null ? this.properties : new Properties();
    }

    @Override
    public Serializable getPersistentUserData() {
        return (Serializable)this.stepExecution.getExecutionContext().get(this.executionContextUserSupport.getKey(PERSISTENT_USER_DATA_KEY));
    }

    @Override
    public void setPersistentUserData(Serializable data) {
        this.stepExecution.getExecutionContext().put(this.executionContextUserSupport.getKey(PERSISTENT_USER_DATA_KEY), data);
    }

    @Override
    public BatchStatus getBatchStatus() {
        return this.stepExecution.getStatus().getBatchStatus();
    }

    @Override
    public String getExitStatus() {
        return this.exitStatusSet.get() ? this.stepExecution.getExitStatus().getExitCode() : null;
    }

    @Override
    public void setExitStatus(String status) {
        this.stepExecution.setExitStatus(new ExitStatus(status));
        this.exitStatusSet.set(true);
    }

    @Override
    public Exception getException() {
        List<Throwable> failureExceptions = this.stepExecution.getFailureExceptions();
        if (failureExceptions == null || failureExceptions.isEmpty()) {
            return null;
        }
        Throwable t2 = failureExceptions.get(failureExceptions.size() - 1);
        if (t2 instanceof Exception) {
            return (Exception)t2;
        }
        return new Exception(t2);
    }

    @Override
    public Metric[] getMetrics() {
        Metric[] metrics = new Metric[]{new SimpleMetric(Metric.MetricType.COMMIT_COUNT, this.stepExecution.getCommitCount()), new SimpleMetric(Metric.MetricType.FILTER_COUNT, this.stepExecution.getFilterCount()), new SimpleMetric(Metric.MetricType.PROCESS_SKIP_COUNT, this.stepExecution.getProcessSkipCount()), new SimpleMetric(Metric.MetricType.READ_COUNT, this.stepExecution.getReadCount()), new SimpleMetric(Metric.MetricType.READ_SKIP_COUNT, this.stepExecution.getReadSkipCount()), new SimpleMetric(Metric.MetricType.ROLLBACK_COUNT, this.stepExecution.getRollbackCount()), new SimpleMetric(Metric.MetricType.WRITE_COUNT, this.stepExecution.getWriteCount()), new SimpleMetric(Metric.MetricType.WRITE_SKIP_COUNT, this.stepExecution.getWriteSkipCount())};
        return metrics;
    }
}

