/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.Collection;
import org.springframework.batch.core.jsr.configuration.support.BatchArtifactType;
import org.springframework.batch.core.jsr.configuration.xml.DecisionStepFactoryBean;
import org.springframework.batch.core.jsr.configuration.xml.FlowParser;
import org.springframework.batch.core.jsr.configuration.xml.PropertyParser;
import org.springframework.batch.core.jsr.job.flow.support.state.JsrStepState;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JsrDecisionParser {
    private static final String ID_ATTRIBUTE = "id";
    private static final String REF_ATTRIBUTE = "ref";

    public Collection<BeanDefinition> parse(Element element, ParserContext parserContext, String jobFactoryRef) {
        BeanDefinitionBuilder factoryBuilder = BeanDefinitionBuilder.genericBeanDefinition();
        AbstractBeanDefinition factoryDefinition = factoryBuilder.getRawBeanDefinition();
        factoryDefinition.setBeanClass(DecisionStepFactoryBean.class);
        BeanDefinitionBuilder stateBuilder = BeanDefinitionBuilder.genericBeanDefinition(JsrStepState.class);
        String idAttribute = element.getAttribute(ID_ATTRIBUTE);
        parserContext.registerBeanComponent(new BeanComponentDefinition(factoryDefinition, idAttribute));
        stateBuilder.addConstructorArgReference(idAttribute);
        String refAttribute = element.getAttribute(REF_ATTRIBUTE);
        factoryDefinition.getPropertyValues().add("decider", new RuntimeBeanReference(refAttribute));
        factoryDefinition.getPropertyValues().add("name", idAttribute);
        if (StringUtils.hasText(jobFactoryRef)) {
            factoryDefinition.setAttribute("jobParserJobFactoryBeanRef", jobFactoryRef);
        }
        new PropertyParser(refAttribute, parserContext, BatchArtifactType.STEP_ARTIFACT, idAttribute).parseProperties(element);
        return FlowParser.getNextElements(parserContext, stateBuilder.getBeanDefinition(), element);
    }
}

