/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.partition.support;

import org.springframework.batch.core.jsr.configuration.xml.StepFactoryBean;
import org.springframework.batch.core.jsr.partition.JsrPartitionHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;

public class JsrBeanScopeBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private JobLevelBeanLazyInitializer initializer;

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        if (this.initializer == null) {
            this.initializer = new JobLevelBeanLazyInitializer(beanFactory);
        }
        for (String curName : beanNames = beanFactory.getBeanDefinitionNames()) {
            this.initializer.visitBeanDefinition(beanFactory.getBeanDefinition(curName));
        }
    }

    public static class JobLevelBeanLazyInitializer {
        private ConfigurableListableBeanFactory beanFactory;

        public JobLevelBeanLazyInitializer(ConfigurableListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public void visitBeanDefinition(BeanDefinition beanDefinition) {
            PropertyValue[] values;
            String beanClassName = beanDefinition.getBeanClassName();
            if (StepFactoryBean.class.getName().equals(beanClassName)) {
                for (PropertyValue propertyValue : values = beanDefinition.getPropertyValues().getPropertyValues()) {
                    if (!propertyValue.getName().equalsIgnoreCase("partitionReducer")) continue;
                    RuntimeBeanReference ref = (RuntimeBeanReference)propertyValue.getValue();
                    this.beanFactory.getBeanDefinition(ref.getBeanName()).setLazyInit(true);
                }
            }
            if (JsrPartitionHandler.class.getName().equals(beanClassName)) {
                for (PropertyValue propertyValue : values = beanDefinition.getPropertyValues().getPropertyValues()) {
                    String propertyName = propertyValue.getName();
                    if (!propertyName.equalsIgnoreCase("partitionMapper") && !propertyName.equalsIgnoreCase("partitionAnalyzer")) continue;
                    RuntimeBeanReference ref = (RuntimeBeanReference)propertyValue.getValue();
                    this.beanFactory.getBeanDefinition(ref.getBeanName()).setLazyInit(true);
                }
            }
        }
    }
}

