/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.step.batchlet;

import javax.batch.api.Batchlet;
import javax.batch.operations.BatchRuntimeException;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.StoppableTasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BatchletAdapter
implements StoppableTasklet {
    private Batchlet batchlet;

    public BatchletAdapter(Batchlet batchlet) {
        Assert.notNull((Object)batchlet, "A Batchlet implementation is required");
        this.batchlet = batchlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        String exitStatus;
        try {
            exitStatus = this.batchlet.process();
        }
        finally {
            chunkContext.setComplete();
        }
        if (StringUtils.hasText(exitStatus)) {
            contribution.setExitStatus(new ExitStatus(exitStatus));
        }
        return RepeatStatus.FINISHED;
    }

    @Override
    public void stop() {
        try {
            this.batchlet.stop();
        }
        catch (Exception e) {
            throw new BatchRuntimeException(e);
        }
    }
}

