/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.avro.builder;

import org.springframework.batch.item.avro.AvroItemReader;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AvroItemReaderBuilder<T> {
    private boolean saveState = true;
    private String name = AvroItemReader.class.getSimpleName();
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;
    private Resource schema;
    private Resource resource;
    private Class<T> type;
    private boolean embeddedSchema = true;

    public AvroItemReaderBuilder<T> resource(Resource resource) {
        Assert.notNull((Object)resource, "A 'resource' is required.");
        Assert.state(resource.exists(), "Resource " + resource.getFilename() + " does not exist.");
        this.resource = resource;
        return this;
    }

    public AvroItemReaderBuilder<T> schema(Resource schema) {
        Assert.notNull((Object)schema, "A 'schema' Resource is required.");
        Assert.state(schema.exists(), "Resource " + schema.getFilename() + " does not exist.");
        this.schema = schema;
        return this;
    }

    public AvroItemReaderBuilder<T> schema(String schemaString) {
        Assert.hasText(schemaString, "A 'schema' is required.");
        this.schema = new ByteArrayResource(schemaString.getBytes());
        return this;
    }

    public AvroItemReaderBuilder<T> type(Class<T> type) {
        Assert.notNull(type, "A 'type' is required.");
        this.type = type;
        return this;
    }

    public AvroItemReaderBuilder<T> embeddedSchema(boolean embeddedSchema) {
        this.embeddedSchema = embeddedSchema;
        return this;
    }

    public AvroItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public AvroItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public AvroItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public AvroItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public AvroItemReader<T> build() {
        Assert.notNull((Object)this.resource, "A 'resource' is required.");
        AvroItemReader<T> avroItemReader = this.type != null ? this.buildForType() : this.buildForSchema();
        avroItemReader.setSaveState(this.saveState);
        if (this.saveState) {
            Assert.state(StringUtils.hasText(this.name), "A name is required when saveState is set to true.");
        }
        avroItemReader.setName(this.name);
        avroItemReader.setCurrentItemCount(this.currentItemCount);
        avroItemReader.setMaxItemCount(this.maxItemCount);
        avroItemReader.setEmbeddedSchema(this.embeddedSchema);
        return avroItemReader;
    }

    private AvroItemReader<T> buildForType() {
        Assert.isNull((Object)this.schema, "You cannot specify a schema and 'type'.");
        return new AvroItemReader<T>(this.resource, this.type);
    }

    private AvroItemReader<T> buildForSchema() {
        Assert.notNull((Object)this.schema, "'schema' is required.");
        return new AvroItemReader(this.resource, this.schema);
    }
}

