/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.springframework.batch.item.database.orm.HibernateQueryProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class HibernateItemReaderHelper<T>
implements InitializingBean {
    private SessionFactory sessionFactory;
    private String queryString = "";
    private String queryName = "";
    private HibernateQueryProvider<? extends T> queryProvider;
    private boolean useStatelessSession = true;
    private StatelessSession statelessSession;
    private Session statefulSession;

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setQueryProvider(HibernateQueryProvider<? extends T> queryProvider) {
        this.queryProvider = queryProvider;
    }

    public void setUseStatelessSession(boolean useStatelessSession) {
        Assert.state(this.statefulSession == null && this.statelessSession == null, "The useStatelessSession flag can only be set before a session is initialized.");
        this.useStatelessSession = useStatelessSession;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.sessionFactory != null, "A SessionFactory must be provided");
        if (this.queryProvider == null) {
            Assert.notNull((Object)this.sessionFactory, "session factory must be set");
            Assert.state(StringUtils.hasText(this.queryString) ^ StringUtils.hasText(this.queryName), "queryString or queryName must be set");
        }
    }

    public ScrollableResults getForwardOnlyCursor(int fetchSize, Map<String, Object> parameterValues) {
        Query query2 = this.createQuery();
        if (!CollectionUtils.isEmpty(parameterValues)) {
            query2.setProperties(parameterValues);
        }
        return query2.setFetchSize(fetchSize).scroll(ScrollMode.FORWARD_ONLY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Query createQuery() {
        if (this.useStatelessSession) {
            if (this.statelessSession == null) {
                this.statelessSession = this.sessionFactory.openStatelessSession();
            }
            if (this.queryProvider != null) {
                this.queryProvider.setStatelessSession(this.statelessSession);
                return this.queryProvider.createQuery();
            }
            if (!StringUtils.hasText(this.queryName)) return this.statelessSession.createQuery(this.queryString);
            return this.statelessSession.getNamedQuery(this.queryName);
        }
        if (this.statefulSession == null) {
            this.statefulSession = this.sessionFactory.openSession();
        }
        if (this.queryProvider != null) {
            this.queryProvider.setSession(this.statefulSession);
            return this.queryProvider.createQuery();
        }
        if (!StringUtils.hasText(this.queryName)) return this.statefulSession.createQuery(this.queryString);
        return this.statefulSession.getNamedQuery(this.queryName);
    }

    public void jumpToItem(ScrollableResults cursor, int itemIndex, int flushInterval) {
        for (int i = 0; i < itemIndex; ++i) {
            cursor.next();
            if (i % flushInterval != 0 || this.useStatelessSession) continue;
            this.statefulSession.clear();
        }
    }

    public void close() {
        if (this.statelessSession != null) {
            this.statelessSession.close();
            this.statelessSession = null;
        }
        if (this.statefulSession != null) {
            Method close = ReflectionUtils.findMethod(Session.class, "close");
            ReflectionUtils.invokeMethod(close, this.statefulSession);
            this.statefulSession = null;
        }
    }

    public Collection<? extends T> readPage(int page, int pageSize, int fetchSize, Map<String, Object> parameterValues) {
        this.clear();
        Query query2 = this.createQuery();
        if (!CollectionUtils.isEmpty(parameterValues)) {
            query2.setProperties(parameterValues);
        }
        List result = query2.setFetchSize(fetchSize).setFirstResult(page * pageSize).setMaxResults(pageSize).list();
        return result;
    }

    public void clear() {
        if (this.statefulSession != null) {
            this.statefulSession.clear();
        }
    }
}

