/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import org.springframework.util.Assert;

public class Range {
    public static final int UPPER_BORDER_NOT_DEFINED = Integer.MAX_VALUE;
    private final int min;
    private final int max;

    public Range(int min2) {
        this(min2, Integer.MAX_VALUE);
    }

    public Range(int min2, int max) {
        this.checkMinMaxValues(min2, max);
        this.min = min2;
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public boolean hasMaxValue() {
        return this.max != Integer.MAX_VALUE;
    }

    public String toString() {
        return this.hasMaxValue() ? this.min + "-" + this.max : String.valueOf(this.min);
    }

    private void checkMinMaxValues(int min2, int max) {
        Assert.isTrue(min2 > 0, "Min value must be higher than zero");
        Assert.isTrue(min2 <= max, "Min value should be lower or equal to max value");
    }
}

