/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.json.builder;

import org.springframework.batch.item.file.FlatFileFooterCallback;
import org.springframework.batch.item.file.FlatFileHeaderCallback;
import org.springframework.batch.item.json.JsonFileItemWriter;
import org.springframework.batch.item.json.JsonObjectMarshaller;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class JsonFileItemWriterBuilder<T> {
    private Resource resource;
    private JsonObjectMarshaller<T> jsonObjectMarshaller;
    private FlatFileHeaderCallback headerCallback;
    private FlatFileFooterCallback footerCallback;
    private String name;
    private String encoding = "UTF-8";
    private String lineSeparator = JsonFileItemWriter.DEFAULT_LINE_SEPARATOR;
    private boolean append = false;
    private boolean forceSync = false;
    private boolean saveState = true;
    private boolean shouldDeleteIfExists = true;
    private boolean shouldDeleteIfEmpty = false;
    private boolean transactional = true;

    public JsonFileItemWriterBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public JsonFileItemWriterBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public JsonFileItemWriterBuilder<T> forceSync(boolean forceSync) {
        this.forceSync = forceSync;
        return this;
    }

    public JsonFileItemWriterBuilder<T> lineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this;
    }

    public JsonFileItemWriterBuilder<T> jsonObjectMarshaller(JsonObjectMarshaller<T> jsonObjectMarshaller) {
        this.jsonObjectMarshaller = jsonObjectMarshaller;
        return this;
    }

    public JsonFileItemWriterBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public JsonFileItemWriterBuilder<T> encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public JsonFileItemWriterBuilder<T> shouldDeleteIfEmpty(boolean shouldDelete) {
        this.shouldDeleteIfEmpty = shouldDelete;
        return this;
    }

    public JsonFileItemWriterBuilder<T> shouldDeleteIfExists(boolean shouldDelete) {
        this.shouldDeleteIfExists = shouldDelete;
        return this;
    }

    public JsonFileItemWriterBuilder<T> append(boolean append) {
        this.append = append;
        return this;
    }

    public JsonFileItemWriterBuilder<T> headerCallback(FlatFileHeaderCallback callback) {
        this.headerCallback = callback;
        return this;
    }

    public JsonFileItemWriterBuilder<T> footerCallback(FlatFileFooterCallback callback) {
        this.footerCallback = callback;
        return this;
    }

    public JsonFileItemWriterBuilder<T> transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public JsonFileItemWriter<T> build() {
        Assert.notNull((Object)this.resource, "A resource is required.");
        Assert.notNull(this.jsonObjectMarshaller, "A json object marshaller is required.");
        if (this.saveState) {
            Assert.hasText(this.name, "A name is required when saveState is true");
        }
        JsonFileItemWriter<T> jsonFileItemWriter = new JsonFileItemWriter<T>(this.resource, this.jsonObjectMarshaller);
        jsonFileItemWriter.setName(this.name);
        jsonFileItemWriter.setAppendAllowed(this.append);
        jsonFileItemWriter.setEncoding(this.encoding);
        if (this.headerCallback != null) {
            jsonFileItemWriter.setHeaderCallback(this.headerCallback);
        }
        if (this.footerCallback != null) {
            jsonFileItemWriter.setFooterCallback(this.footerCallback);
        }
        jsonFileItemWriter.setForceSync(this.forceSync);
        jsonFileItemWriter.setLineSeparator(this.lineSeparator);
        jsonFileItemWriter.setSaveState(this.saveState);
        jsonFileItemWriter.setShouldDeleteIfEmpty(this.shouldDeleteIfEmpty);
        jsonFileItemWriter.setShouldDeleteIfExists(this.shouldDeleteIfExists);
        jsonFileItemWriter.setTransactional(this.transactional);
        return jsonFileItemWriter;
    }
}

