/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.validator;

import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.validator.ValidationException;
import org.springframework.batch.item.validator.Validator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ValidatingItemProcessor<T>
implements ItemProcessor<T, T>,
InitializingBean {
    private Validator<? super T> validator;
    private boolean filter = false;

    public ValidatingItemProcessor() {
    }

    public ValidatingItemProcessor(Validator<? super T> validator) {
        this.validator = validator;
    }

    public void setValidator(Validator<? super T> validator) {
        this.validator = validator;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    @Override
    @Nullable
    public T process(T item) throws ValidationException {
        try {
            this.validator.validate(item);
        }
        catch (ValidationException e) {
            if (this.filter) {
                return null;
            }
            throw e;
        }
        return item;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.validator, "Validator must not be null.");
    }
}

