/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.jsr.item;

import java.io.Serializable;
import java.util.List;
import javax.batch.api.chunk.ItemWriter;
import org.springframework.batch.jsr.item.CheckpointSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ItemWriterAdapter<T>
extends CheckpointSupport
implements org.springframework.batch.item.ItemWriter<T> {
    private static final String CHECKPOINT_KEY = "writer.checkpoint";
    private ItemWriter delegate;

    public ItemWriterAdapter(ItemWriter writer) {
        super(CHECKPOINT_KEY);
        Assert.notNull((Object)writer, "An ItemWriter implementation is required");
        this.delegate = writer;
        super.setExecutionContextName(ClassUtils.getShortName(this.delegate.getClass()));
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        this.delegate.writeItems(items);
    }

    @Override
    protected void doOpen(Serializable checkpoint) throws Exception {
        this.delegate.open(checkpoint);
    }

    @Override
    protected Serializable doCheckpoint() throws Exception {
        Serializable checkpointInfo = this.delegate.checkpointInfo();
        return checkpointInfo;
    }

    @Override
    protected void doClose() throws Exception {
        this.delegate.close();
    }
}

