/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import java.net.URL;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastConfigResourceCondition;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={HazelcastInstance.class})
class HazelcastServerConfiguration {
    static final String CONFIG_SYSTEM_PROPERTY = "hazelcast.config";

    HazelcastServerConfiguration() {
    }

    private static HazelcastInstance getHazelcastInstance(Config config) {
        if (StringUtils.hasText(config.getInstanceName())) {
            return Hazelcast.getOrCreateHazelcastInstance((Config)config);
        }
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    static class ConfigAvailableCondition
    extends HazelcastConfigResourceCondition {
        ConfigAvailableCondition() {
            super(HazelcastServerConfiguration.CONFIG_SYSTEM_PROPERTY, new String[]{"file:./hazelcast.xml", "classpath:/hazelcast.xml", "file:./hazelcast.yaml", "classpath:/hazelcast.yaml", "file:./hazelcast.yml", "classpath:/hazelcast.yml"});
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSingleCandidate(value=Config.class)
    static class HazelcastServerConfigConfiguration {
        HazelcastServerConfigConfiguration() {
        }

        @Bean
        HazelcastInstance hazelcastInstance(Config config) {
            return HazelcastServerConfiguration.getHazelcastInstance(config);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={Config.class})
    @Conditional(value={ConfigAvailableCondition.class})
    static class HazelcastServerConfigFileConfiguration {
        HazelcastServerConfigFileConfiguration() {
        }

        @Bean
        HazelcastInstance hazelcastInstance(HazelcastProperties properties, ResourceLoader resourceLoader) throws IOException {
            Resource configLocation = properties.resolveConfigLocation();
            Config config = configLocation != null ? this.loadConfig(configLocation) : Config.load();
            config.setClassLoader(resourceLoader.getClassLoader());
            return HazelcastServerConfiguration.getHazelcastInstance(config);
        }

        private Config loadConfig(Resource configLocation) throws IOException {
            URL configUrl = configLocation.getURL();
            Config config = HazelcastServerConfigFileConfiguration.loadConfig(configUrl);
            if (ResourceUtils.isFileURL(configUrl)) {
                config.setConfigurationFile(configLocation.getFile());
            } else {
                config.setConfigurationUrl(configUrl);
            }
            return config;
        }

        private static Config loadConfig(URL configUrl) throws IOException {
            String configFileName = configUrl.getPath();
            if (configFileName.endsWith(".yaml") || configFileName.endsWith(".yml")) {
                return new YamlConfigBuilder(configUrl).build();
            }
            return new XmlConfigBuilder(configUrl).build();
        }
    }
}

