--------------------------------------------------------------------------------
-- copy of the content schemas taken from NXRM's DAO XML files
--------------------------------------------------------------------------------

CREATE TABLE ${format}_content_repository
(
    repository_id        INT GENERATED BY DEFAULT AS IDENTITY,
    config_repository_id UUID      NOT NULL,
    attributes           JSON      NOT NULL,
    created              TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP,
    last_updated         TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT           pk_${format}_content_repository_id PRIMARY KEY (repository_id),
    CONSTRAINT           uk_${format}_config_repository_id UNIQUE (config_repository_id)
);

CREATE TABLE ${format}_component
(
    component_id  INT GENERATED BY DEFAULT AS IDENTITY,
    repository_id INT       NOT NULL,
    namespace     VARCHAR   NOT NULL,
    name          VARCHAR   NOT NULL,
    kind          VARCHAR   NOT NULL,
    version       VARCHAR   NOT NULL,
    attributes    JSON      NOT NULL,
    created       TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP,
    last_updated  TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT    pk_${format}_component_id PRIMARY KEY (component_id),
    CONSTRAINT    uk_${format}_component_coordinate UNIQUE (repository_id, namespace, name, version),

    CONSTRAINT    fk_${format}_component_repository FOREIGN KEY (repository_id)
        REFERENCES ${format}_content_repository (repository_id)
);

CREATE INDEX IF NOT EXISTS idx_${format}_component_kind ON ${format}_component (kind);

CREATE TABLE ${format}_component_tag
(
  component_tag_id INT GENERATED BY DEFAULT AS IDENTITY,
  component_id  INT NOT NULL,
  tag_id        INT NOT NULL,
  CONSTRAINT pk_${format}_component_tag_component_tag_id PRIMARY KEY (component_tag_id),
  CONSTRAINT uk_${format}_component_tag_component_id_tag_id UNIQUE (component_id, tag_id),
  CONSTRAINT fk_${format}_tag_id FOREIGN KEY (tag_id) REFERENCES tag(id) ON DELETE CASCADE
);

CREATE TABLE ${format}_asset_blob
(
    asset_blob_id INT GENERATED BY DEFAULT AS IDENTITY,
    blob_ref      VARCHAR   NOT NULL,
    blob_size     BIGINT    NOT NULL,
    content_type  VARCHAR   NOT NULL,
    checksums     JSON      NOT NULL,
    blob_created  TIMESTAMP WITH TIME ZONE NOT NULL,
    created_by    VARCHAR,
    created_by_ip VARCHAR,
    added_to_repository TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT    pk_${format}_asset_blob_id PRIMARY KEY (asset_blob_id),
    CONSTRAINT    uk_${format}_asset_blob_ref UNIQUE (blob_ref)
);

DROP INDEX IF EXISTS idx_${format}_asset_blob_blob_created;

CREATE INDEX IF NOT EXISTS idx_${format}_asset_blob_added_to_repository ON ${format}_asset_blob (added_to_repository);

CREATE TABLE ${format}_asset
(
    asset_id        INT GENERATED BY DEFAULT AS IDENTITY,
    repository_id   INT       NOT NULL,
    path            VARCHAR   NOT NULL,
    kind            VARCHAR   NOT NULL,
    component_id    INT,
    asset_blob_id   INT,
    last_downloaded TIMESTAMP WITH TIME ZONE,
    attributes      JSON      NOT NULL,
    created         TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP,
    last_updated    TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT      pk_${format}_asset_id PRIMARY KEY (asset_id),
    CONSTRAINT      uk_${format}_asset_repository_path UNIQUE (repository_id, path),

    CONSTRAINT      fk_${format}_asset_repository FOREIGN KEY (repository_id)
        REFERENCES ${format}_content_repository (repository_id),
    CONSTRAINT      fk_${format}_asset_component FOREIGN KEY (component_id)
        REFERENCES ${format}_component (component_id),
    CONSTRAINT      fk_${format}_asset_blob FOREIGN KEY (asset_blob_id)
        REFERENCES ${format}_asset_blob (asset_blob_id)
);

CREATE INDEX IF NOT EXISTS idx_${format}_asset_kind      ON ${format}_asset (kind);
CREATE INDEX IF NOT EXISTS idx_${format}_asset_component ON ${format}_asset (component_id);
CREATE INDEX IF NOT EXISTS idx_${format}_asset_blob      ON ${format}_asset (asset_blob_id);
