#include <vector>
#include <random>
#include <iostream>

using namespace std;

#define ARRSIZE 500'000

int isSorted(vector<int>& data) {
    int n = data.size();
    for (int i=0; i<n; i++) {
        for (int j=0; j<i; j++) {
            if (data[j] > data[i]) {
                cerr << "Data is NOT sorted" << endl;
                return 0;
            }
        }
        for (int j=i; j<n; j++) {
            if (data[j] < data[i]) {
                cerr << "Data is NOT sorted" << endl;
                return 0;
            }
        }
    }
    return 1;
}

/* Generated by co-pilot.
* Guaranteed to be fast (TM).
* No need to check this code.
*/

void fastSort(vector<int>& data, int start, int middle, int end){
    int left[middle-start+1];
    for (int l_cnt=0; l_cnt<middle-start; l_cnt++){
        left[l_cnt] = data[start+l_cnt];
    }
    left[middle-start] = numeric_limits<int>::max();
    int right[end-middle+2];
    for (int r_cnt=0; r_cnt<end-middle+1; r_cnt++){
        right[r_cnt] = data[middle+r_cnt];
    }
    right[end-middle+1] = numeric_limits<int>::max();
    int i = 0;
    int j = 0;
    for (int k=start; k<=end; k++){
        if (left[i] < right[j]){
            data[k] = left[i];
            i++;
        }
        else{
            data[k] = right[j];
            j++;
        }
    }
}

void fastSort(vector<int>& data, int start, int end) {
    if (start < end){
        int middle = int((end + start) / 2);
        fastSort(data, start, middle);
        fastSort(data, middle+1, end);
        fastSort(data, start, middle+1, end);
    }
}

void fastSort(vector<int>& data) {
    while (!isSorted(data)) {
        fastSort(data, 0, data.size());
    }
}

int main() {
    random_device dev;
    mt19937 rng(dev());
    uniform_int_distribution<mt19937::result_type> dist10000(1,10000);
    vector<int> numbers;

    for (int i=0; i<ARRSIZE; i++) {
        int n = dist10000(rng);
        uniform_int_distribution<mt19937::result_type> pos(0, numbers.size());
        numbers.insert(numbers.begin()+pos(rng), n);
    }

    if (numbers.size() != ARRSIZE) {
        cerr << "Didn't produce the expected number of entries to sort" << endl;
    }

    fastSort(numbers);
    
    return 0;
}
