/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.ErrorPropagatingOutputStream;
import hudson.remoting.Pipe;
import hudson.remoting.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

public class RemoteInputStream
extends InputStream
implements SerializableOnlyOverRemoting {
    private static final Logger LOGGER = Logger.getLogger(RemoteInputStream.class.getName());
    private transient InputStream core;
    private final boolean autoUnexport;
    private transient Greedy greedyAt;
    private final boolean greedy;
    private static final long serialVersionUID = 1L;

    @Deprecated
    public RemoteInputStream(InputStream core) {
        this(core, Flag.NOT_GREEDY);
    }

    @Deprecated
    public RemoteInputStream(InputStream core, boolean autoUnexport) {
        this(core, Flag.NOT_GREEDY, autoUnexport ? Flag.NOT_GREEDY : Flag.MANUAL_UNEXPORT);
    }

    public RemoteInputStream(InputStream core, Flag f) {
        this(core, EnumSet.of(f));
    }

    public RemoteInputStream(InputStream core, Flag f1, Flag f2) {
        this(core, EnumSet.of(f1, f2));
    }

    public RemoteInputStream(InputStream core, Set<Flag> flags) {
        this.core = core;
        this.greedy = flags.contains((Object)Flag.GREEDY);
        if (this.greedy) {
            this.greedyAt = new Greedy();
        }
        this.autoUnexport = !flags.contains((Object)Flag.MANUAL_UNEXPORT);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Channel ch = this.getChannelForSerialization();
        if (ch.remoteCapability.supportsGreedyRemoteInputStream()) {
            oos.writeBoolean(this.greedy);
            if (this.greedy) {
                Pipe pipe = Pipe.createLocalToRemote();
                InputStream i = this.core;
                OutputStream o = pipe.getOut();
                new PumpThread("RemoteInputStream greedy pump thread: " + this.greedyAt.print(), i, o).start();
                oos.writeObject(pipe);
                return;
            }
        }
        int id = ch.internalExport(InputStream.class, this.core, this.autoUnexport);
        oos.writeInt(id);
    }

    @SuppressFBWarnings(value={"DESERIALIZATION_GADGET", "MC_OVERRIDABLE_METHOD_CALL_IN_READ_OBJECT"}, justification="Serializable only over remoting. Class filtering is done through JEP-200.")
    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        boolean greedy;
        Channel channel = this.getChannelForSerialization();
        if (channel.remoteCapability.supportsGreedyRemoteInputStream() && (greedy = ois.readBoolean())) {
            Pipe p = (Pipe)ois.readObject();
            this.core = p.getIn();
            return;
        }
        this.core = new ProxyInputStream(channel, ois.readInt());
    }

    @Override
    public int read() throws IOException {
        return this.core.read();
    }

    @Override
    public int read(@NonNull byte[] b) throws IOException {
        return this.core.read(b);
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        return this.core.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.core.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.core.available();
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    @Override
    public void mark(int readlimit) {
        this.core.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.core.reset();
    }

    @Override
    public boolean markSupported() {
        return this.core.markSupported();
    }

    public static enum Flag {
        GREEDY,
        NOT_GREEDY,
        MANUAL_UNEXPORT;

    }

    private static final class Greedy
    extends Exception {
        private Greedy() {
        }

        public String print() {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                this.printStackTrace(pw);
            }
            return sw.toString();
        }
    }

    private static class PumpThread
    extends Thread {
        private final InputStream i;
        private final OutputStream o;

        public PumpThread(String name, InputStream i, OutputStream o) {
            super(name);
            this.i = Objects.requireNonNull(i);
            this.o = Objects.requireNonNull(o);
            this.setUncaughtExceptionHandler((t, e) -> LOGGER.log(Level.SEVERE, "Uncaught exception in RemoteInputStream pump thread " + String.valueOf(t), e));
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] buf = new byte[8192];
                while (true) {
                    int len;
                    block24: {
                        try {
                            len = this.i.read(buf);
                            if (len >= 0) break block24;
                            break;
                        }
                        catch (IOException e) {
                            if (this.o instanceof ErrorPropagatingOutputStream) {
                                try {
                                    ((ErrorPropagatingOutputStream)((Object)this.o)).error(e);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            try {
                                this.i.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                this.o.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    try {
                        this.o.write(buf, 0, len);
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    this.i.close();
                }
                catch (IOException iOException) {}
                try {
                    this.o.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

