/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git.traits;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RemoteNameSCMSourceTrait
extends SCMSourceTrait {
    @NonNull
    private final String remoteName;

    @DataBoundConstructor
    public RemoteNameSCMSourceTrait(@CheckForNull String remoteName) {
        this.remoteName = RemoteNameSCMSourceTrait.validate(StringUtils.defaultIfBlank((String)StringUtils.trimToEmpty((String)remoteName), (String)"origin"));
    }

    @NonNull
    public String getRemoteName() {
        return this.remoteName;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        ((GitSCMSourceContext)context).withRemoteName(this.remoteName);
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        ((GitSCMBuilder)builder).withRemoteName(this.remoteName);
    }

    @NonNull
    private static String validate(@NonNull String value) {
        if (value.contains("..")) {
            throw new IllegalArgumentException("Remote name cannot contain '..'");
        }
        if (value.contains("//")) {
            throw new IllegalArgumentException("Remote name cannot contain empty path segments");
        }
        if (value.endsWith("/")) {
            throw new IllegalArgumentException("Remote name cannot end with '/'");
        }
        if (value.startsWith("/")) {
            throw new IllegalArgumentException("Remote name cannot start with '/'");
        }
        if (value.endsWith(".lock")) {
            throw new IllegalArgumentException("Remote name cannot end with '.lock'");
        }
        if (value.contains("@{")) {
            throw new IllegalArgumentException("Remote name cannot contain '@{'");
        }
        for (String component : StringUtils.split((String)value, (char)'/')) {
            if (component.startsWith(".")) {
                throw new IllegalArgumentException("Remote name cannot contain path segments starting with '.'");
            }
            if (!component.endsWith(".lock")) continue;
            throw new IllegalArgumentException("Remote name cannot contain path segments ending with '.lock'");
        }
        for (char c : value.toCharArray()) {
            if (c < ' ') {
                throw new IllegalArgumentException("Remote name cannot contain ASCII control characters");
            }
            switch (c) {
                case ':': {
                    throw new IllegalArgumentException("Remote name cannot contain ':'");
                }
                case '?': {
                    throw new IllegalArgumentException("Remote name cannot contain '?'");
                }
                case '[': {
                    throw new IllegalArgumentException("Remote name cannot contain '['");
                }
                case '\\': {
                    throw new IllegalArgumentException("Remote name cannot contain '\\'");
                }
                case '^': {
                    throw new IllegalArgumentException("Remote name cannot contain '^'");
                }
                case '~': {
                    throw new IllegalArgumentException("Remote name cannot contain '~'");
                }
                case ' ': {
                    throw new IllegalArgumentException("Remote name cannot contain SPACE");
                }
                case '\t': {
                    throw new IllegalArgumentException("Remote name cannot contain TAB");
                }
                case '*': {
                    throw new IllegalArgumentException("Remote name cannot contain '*'");
                }
            }
        }
        return value;
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return "Configure remote name";
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCM> getScmClass() {
            return GitSCM.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitSCMSourceContext.class;
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRemoteName(@QueryParameter String value) {
            if (StringUtils.isBlank((String)(value = StringUtils.trimToEmpty((String)value)))) {
                return FormValidation.error((String)"You must specify a remote name");
            }
            if ("origin".equals(value)) {
                return FormValidation.warning((String)"There is no need to configure a remote name of '%s' as this is the default remote name.", (Object[])new Object[]{"origin"});
            }
            try {
                RemoteNameSCMSourceTrait.validate(value);
                return FormValidation.ok();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

