/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Functions;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.util.ClassLoaderSanityThreadFactory;
import hudson.util.DaemonThreadFactory;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.NamingThreadFactory;
import hudson.util.NullStream;
import hudson.util.ProcessTree;
import hudson.util.StreamCopyThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.input.NullInputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class Proc {
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ExceptionCatchingThreadFactory(new NamingThreadFactory(new ClassLoaderSanityThreadFactory(new DaemonThreadFactory()), "Proc.executor")));
    private static final Logger LOGGER = Logger.getLogger(Proc.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for debugging")
    public static boolean SHOW_PID = false;

    protected Proc() {
    }

    public abstract boolean isAlive() throws IOException, InterruptedException;

    public abstract void kill() throws IOException, InterruptedException;

    public abstract int join() throws IOException, InterruptedException;

    @CheckForNull
    public abstract InputStream getStdout();

    @CheckForNull
    public abstract InputStream getStderr();

    @CheckForNull
    public abstract OutputStream getStdin();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int joinWithTimeout(final long timeout, final TimeUnit unit, final TaskListener listener) throws IOException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!latch.await(timeout, unit)) {
                            listener.error("Timeout after " + timeout + " " + unit.toString().toLowerCase(Locale.ENGLISH));
                            Proc.this.kill();
                        }
                    }
                    catch (IOException | InterruptedException | RuntimeException x) {
                        Functions.printStackTrace((Throwable)x, listener.error("Failed to join a process"));
                    }
                }
            });
            int n = this.join();
            return n;
        }
        finally {
            latch.countDown();
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static interface ProcWithJenkins23271Patch {
    }

    @Deprecated
    public static final class RemoteProc
    extends Proc
    implements ProcWithJenkins23271Patch {
        private final Future<Integer> process;

        public RemoteProc(Future<Integer> process) {
            this.process = process;
        }

        @Override
        public void kill() throws IOException, InterruptedException {
            try {
                this.process.cancel(true);
            }
            finally {
                if (this.isAlive()) {
                    LOGGER.log(Level.WARNING, "Process {0} has not really finished after the kill() method execution", this);
                }
            }
        }

        @Override
        public int join() throws IOException, InterruptedException {
            try {
                int n = this.process.get();
                return n;
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, String.format("Join operation has been interrupted for the process %s. Killing the process", this), e);
                this.kill();
                throw e;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException("Failed to join the process", e);
            }
            catch (CancellationException x) {
                int n = -1;
                return n;
            }
            finally {
                if (this.isAlive()) {
                    LOGGER.log(Level.WARNING, "Process {0} has not really finished after the join() method completion", this);
                }
            }
        }

        @Override
        public boolean isAlive() throws IOException, InterruptedException {
            return !this.process.isDone();
        }

        @Override
        public InputStream getStdout() {
            return null;
        }

        @Override
        public InputStream getStderr() {
            return null;
        }

        @Override
        public OutputStream getStdin() {
            return null;
        }
    }

    public static final class LocalProc
    extends Proc {
        private final Process proc;
        private final Thread copier;
        private final Thread copier2;
        private final OutputStream out;
        private final EnvVars cookie;
        private final String name;
        private final InputStream stdout;
        private final InputStream stderr;
        private final OutputStream stdin;
        public static final InputStream SELFPUMP_INPUT = new NullInputStream(0L);
        public static final OutputStream SELFPUMP_OUTPUT = new NullStream();

        public LocalProc(String cmd, Map<String, String> env, OutputStream out, File workDir) throws IOException {
            this(cmd, Util.mapToEnv(env), out, workDir);
        }

        public LocalProc(String[] cmd, Map<String, String> env, InputStream in, OutputStream out) throws IOException {
            this(cmd, Util.mapToEnv(env), in, out);
        }

        public LocalProc(String cmd, String[] env, OutputStream out, File workDir) throws IOException {
            this(Util.tokenize(cmd), env, out, workDir);
        }

        public LocalProc(String[] cmd, String[] env, OutputStream out, File workDir) throws IOException {
            this(cmd, env, null, out, workDir);
        }

        public LocalProc(String[] cmd, String[] env, InputStream in, OutputStream out) throws IOException {
            this(cmd, env, in, out, null);
        }

        public LocalProc(String[] cmd, String[] env, InputStream in, OutputStream out, File workDir) throws IOException {
            this(cmd, env, in, out, null, workDir);
        }

        @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="Command injection is the point of this old, barely used class.")
        public LocalProc(String[] cmd, String[] env, InputStream in, OutputStream out, OutputStream err, File workDir) throws IOException {
            this(LocalProc.calcName(cmd), LocalProc.stderr(LocalProc.environment(new ProcessBuilder(cmd), env).directory(workDir), err == null || err == SELFPUMP_OUTPUT), in, out, err);
        }

        private static ProcessBuilder stderr(ProcessBuilder pb, boolean redirectError) {
            if (redirectError) {
                pb.redirectErrorStream(true);
            }
            return pb;
        }

        private static ProcessBuilder environment(ProcessBuilder pb, String[] env) {
            if (env != null) {
                Map<String, String> m = pb.environment();
                m.clear();
                for (String e : env) {
                    int idx = e.indexOf(61);
                    m.put(e.substring(0, idx), e.substring(idx + 1));
                }
            }
            return pb;
        }

        private LocalProc(String name, ProcessBuilder procBuilder, InputStream in, OutputStream out, OutputStream err) throws IOException {
            Logger.getLogger(Proc.class.getName()).log(Level.FINE, "Running: {0}", name);
            this.name = name;
            this.out = out;
            this.cookie = EnvVars.createCookie();
            procBuilder.environment().putAll(this.cookie);
            if (procBuilder.directory() != null && !procBuilder.directory().exists()) {
                throw new IOException(String.format("Process working directory '%s' doesn't exist!", procBuilder.directory().getAbsolutePath()));
            }
            this.proc = procBuilder.start();
            InputStream procInputStream = this.proc.getInputStream();
            if (out == SELFPUMP_OUTPUT) {
                this.stdout = procInputStream;
                this.copier = null;
            } else {
                this.copier = new StreamCopyThread(name + ": stdout copier", procInputStream, out);
                this.copier.start();
                this.stdout = null;
            }
            if (in == null) {
                this.stdin = null;
                this.proc.getOutputStream().close();
            } else if (in == SELFPUMP_INPUT) {
                this.stdin = this.proc.getOutputStream();
            } else {
                new StdinCopyThread(name + ": stdin copier", in, this.proc.getOutputStream()).start();
                this.stdin = null;
            }
            InputStream procErrorStream = this.proc.getErrorStream();
            if (err != null) {
                if (err == SELFPUMP_OUTPUT) {
                    this.stderr = procErrorStream;
                    this.copier2 = null;
                } else {
                    this.stderr = null;
                    this.copier2 = new StreamCopyThread(name + ": stderr copier", procErrorStream, err);
                    this.copier2.start();
                }
            } else {
                if (procErrorStream != procInputStream) {
                    procErrorStream.close();
                }
                this.copier2 = null;
                this.stderr = null;
            }
        }

        @Override
        public InputStream getStdout() {
            return this.stdout;
        }

        @Override
        public InputStream getStderr() {
            return this.stderr;
        }

        @Override
        public OutputStream getStdin() {
            return this.stdin;
        }

        @Override
        public int join() throws InterruptedException, IOException {
            Thread t = Thread.currentThread();
            String oldName = t.getName();
            if (SHOW_PID) {
                ProcessTree.OSProcess p = ProcessTree.get().get(this.proc);
                t.setName(oldName + " " + (p != null ? "waiting for pid=" + p.getPid() : "waiting for " + this.name));
            }
            try {
                int r = this.proc.waitFor();
                if (this.copier != null) {
                    this.copier.join(TimeUnit.SECONDS.toMillis(10L));
                }
                if (this.copier2 != null) {
                    this.copier2.join(TimeUnit.SECONDS.toMillis(10L));
                }
                if (this.copier != null && this.copier.isAlive() || this.copier2 != null && this.copier2.isAlive()) {
                    String msg = "Process leaked file descriptors. See https://www.jenkins.io/redirect/troubleshooting/process-leaked-file-descriptors for more information";
                    Throwable e = new Exception().fillInStackTrace();
                    LOGGER.log(Level.WARNING, msg, e);
                    this.out.write(msg.getBytes(Charset.defaultCharset()));
                    this.out.write(10);
                }
                int n = r;
                return n;
            }
            catch (InterruptedException e) {
                this.destroy();
                throw e;
            }
            finally {
                t.setName(oldName);
            }
        }

        @Override
        public boolean isAlive() throws IOException, InterruptedException {
            try {
                this.proc.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }

        @Override
        public void kill() throws InterruptedException, IOException {
            this.destroy();
            this.join();
        }

        private void destroy() throws InterruptedException {
            ProcessTree.get().killAll(this.proc, this.cookie);
        }

        private static String calcName(String[] cmd) {
            return String.join((CharSequence)" ", cmd);
        }

        private static class StdinCopyThread
        extends Thread {
            private final InputStream in;
            private final OutputStream out;

            StdinCopyThread(String threadName, InputStream in, OutputStream out) {
                super(threadName);
                this.in = in;
                this.out = out;
            }

            @Override
            public void run() {
                try {
                    try {
                        int len;
                        byte[] buf = new byte[8192];
                        while ((len = this.in.read(buf)) >= 0) {
                            this.out.write(buf, 0, len);
                            this.out.flush();
                        }
                    }
                    finally {
                        this.in.close();
                        this.out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

