/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.Messages;
import hudson.security.Permission;
import hudson.security.SparseACL;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class FullControlOnceLoggedInAuthorizationStrategy
extends AuthorizationStrategy {
    private boolean denyAnonymousReadAccess = false;
    private static final SparseACL AUTHENTICATED_READ = new SparseACL(null);
    private static final SparseACL ANONYMOUS_READ = new SparseACL(null);
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static Descriptor<AuthorizationStrategy> DESCRIPTOR;

    @DataBoundConstructor
    public FullControlOnceLoggedInAuthorizationStrategy() {
    }

    @Override
    public ACL getRootACL() {
        return this.denyAnonymousReadAccess ? AUTHENTICATED_READ : ANONYMOUS_READ;
    }

    public List<String> getGroups() {
        return Collections.emptyList();
    }

    public boolean isAllowAnonymousRead() {
        return !this.denyAnonymousReadAccess;
    }

    @DataBoundSetter
    public void setAllowAnonymousRead(boolean allowAnonymousRead) {
        this.denyAnonymousReadAccess = !allowAnonymousRead;
    }

    static {
        ANONYMOUS_READ.add(ACL.EVERYONE, Jenkins.ADMINISTER, true);
        ANONYMOUS_READ.add(ACL.ANONYMOUS, Jenkins.ADMINISTER, false);
        ANONYMOUS_READ.add(ACL.ANONYMOUS, Permission.READ, true);
        AUTHENTICATED_READ.add(ACL.EVERYONE, Jenkins.ADMINISTER, true);
        AUTHENTICATED_READ.add(ACL.ANONYMOUS, Jenkins.ADMINISTER, false);
    }

    @Extension
    @Symbol(value={"loggedInUsersCanDoAnything"})
    public static class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="for backward compatibility")
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        public String getDisplayName() {
            return Messages.FullControlOnceLoggedInAuthorizationStrategy_DisplayName();
        }
    }
}

