/*
 * Decompiled with CFR 0.152.
 */
package jenkins.management;

import hudson.Extension;
import hudson.diagnosis.ReverseProxySetupMonitor;
import hudson.model.AdministrativeMonitor;
import hudson.model.PageDecorator;
import hudson.util.HudsonIsLoading;
import hudson.util.HudsonIsRestarting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.diagnostics.URICheckEncodingMonitor;
import jenkins.management.Messages;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Restricted(value={NoExternalUse.class})
public class AdministrativeMonitorsDecorator
extends PageDecorator {
    private final Collection<String> ignoredJenkinsRestOfUrls = new ArrayList<String>();

    public AdministrativeMonitorsDecorator() {
        this.ignoredJenkinsRestOfUrls.add("manage");
        this.ignoredJenkinsRestOfUrls.add("contextMenu");
        this.ignoredJenkinsRestOfUrls.add("configure");
    }

    @Override
    public String getDisplayName() {
        return Messages.AdministrativeMonitorsDecorator_DisplayName();
    }

    public Collection<AdministrativeMonitor> filterNonSecurityAdministrativeMonitors(Collection<AdministrativeMonitor> activeMonitors) {
        return this.filterActiveAdministrativeMonitors(activeMonitors, false);
    }

    public Collection<AdministrativeMonitor> filterSecurityAdministrativeMonitors(Collection<AdministrativeMonitor> activeMonitors) {
        return this.filterActiveAdministrativeMonitors(activeMonitors, true);
    }

    private Collection<AdministrativeMonitor> filterActiveAdministrativeMonitors(Collection<AdministrativeMonitor> activeMonitors, boolean isSecurity) {
        ArrayList<AdministrativeMonitor> active = new ArrayList<AdministrativeMonitor>();
        for (AdministrativeMonitor am : activeMonitors) {
            if (am.isSecurity() != isSecurity) continue;
            active.add(am);
        }
        return active;
    }

    public List<AdministrativeMonitor> getNonSecurityAdministrativeMonitors() {
        Collection<AdministrativeMonitor> allowedMonitors = this.getMonitorsToDisplay();
        if (allowedMonitors == null) {
            return Collections.emptyList();
        }
        return allowedMonitors.stream().filter(administrativeMonitor -> !administrativeMonitor.isSecurity()).collect(Collectors.toList());
    }

    public List<AdministrativeMonitor> getSecurityAdministrativeMonitors() {
        Collection<AdministrativeMonitor> allowedMonitors = this.getMonitorsToDisplay();
        if (allowedMonitors == null) {
            return Collections.emptyList();
        }
        return allowedMonitors.stream().filter(AdministrativeMonitor::isSecurity).collect(Collectors.toList());
    }

    private Collection<AdministrativeMonitor> getAllActiveAdministrativeMonitors() {
        ArrayList<AdministrativeMonitor> active = new ArrayList<AdministrativeMonitor>();
        for (AdministrativeMonitor am : Jenkins.get().getActiveAdministrativeMonitors()) {
            if (am instanceof ReverseProxySetupMonitor || am instanceof URICheckEncodingMonitor) continue;
            active.add(am);
        }
        return active;
    }

    public Collection<AdministrativeMonitor> getMonitorsToDisplay() {
        String url;
        if (!Jenkins.get().hasPermission(Jenkins.SYSTEM_READ)) {
            return null;
        }
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return null;
        }
        List ancestors = req.getAncestors();
        if (ancestors == null || ancestors.size() == 0) {
            return null;
        }
        Ancestor a = (Ancestor)ancestors.get(ancestors.size() - 1);
        Object o = a.getObject();
        if (o instanceof HudsonIsLoading || o instanceof HudsonIsRestarting) {
            return null;
        }
        if (o instanceof Jenkins && this.ignoredJenkinsRestOfUrls.contains(url = a.getRestOfUrl())) {
            return null;
        }
        return this.getAllActiveAdministrativeMonitors();
    }
}

