/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Functions;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.BallColor;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Node;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.jelly.JellyClassTearOff;
import org.kohsuke.stapler.jelly.JellyFacet;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public interface ModelObjectWithContextMenu
extends ModelObject {
    public ContextMenu doContextMenu(StaplerRequest var1, StaplerResponse var2) throws Exception;

    public static interface ContextMenuVisibility
    extends Action {
        public boolean isVisible();
    }

    @ExportedBean
    public static class MenuItem {
        @Exported
        public String url;
        @Exported
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="read by Stapler")
        public String displayName;
        @Exported
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="read by Stapler")
        public String icon;
        @Exported
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="read by Stapler")
        public boolean post;
        @Exported
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="read by Stapler")
        public boolean requiresConfirmation;
        @Exported
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="read by Stapler")
        public boolean header;
        @Exported(inline=true)
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="read by Stapler")
        public ContextMenu subMenu;

        public MenuItem(String url, String icon, String displayName) {
            this.withUrl(url).withIcon(icon).withDisplayName(displayName);
        }

        public MenuItem() {
        }

        public MenuItem withUrl(String url) {
            try {
                this.url = new URI(Stapler.getCurrentRequest().getRequestURI()).resolve(new URI(url)).toString();
            }
            catch (URISyntaxException x) {
                throw new IllegalArgumentException("Bad URI from " + Stapler.getCurrentRequest().getRequestURI() + " vs. " + url, x);
            }
            return this;
        }

        public MenuItem withContextRelativeUrl(String url) {
            if (!url.startsWith("/")) {
                url = '/' + url;
            }
            this.url = Stapler.getCurrentRequest().getContextPath() + url;
            return this;
        }

        public MenuItem withIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public MenuItem withIcon(BallColor color) {
            return this.withStockIcon(color.getImage());
        }

        public MenuItem withStockIcon(String icon) {
            this.icon = this.getResourceUrl() + "/images/24x24/" + icon;
            return this;
        }

        public MenuItem withIconClass(String iconClass) {
            Icon iconByClass = IconSet.icons.getIconByClassSpec((Object)(iconClass + " icon-md"));
            this.icon = iconByClass == null ? null : iconByClass.getQualifiedUrl(this.getResourceUrl());
            return this;
        }

        public MenuItem withDisplayName(String displayName) {
            this.displayName = Util.escape(displayName);
            return this;
        }

        public MenuItem withDisplayName(ModelObject o) {
            return this.withDisplayName(o.getDisplayName());
        }

        private String getResourceUrl() {
            return Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH;
        }
    }

    @ExportedBean
    public static class ContextMenu
    implements HttpResponse {
        @Exported(inline=true)
        public final List<MenuItem> items = new ArrayList<MenuItem>();

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object o) throws IOException, ServletException {
            rsp.serveExposedBean(req, (Object)this, Flavor.JSON);
        }

        public ContextMenu add(String url, String text) {
            this.items.add(new MenuItem(url, null, text));
            return this;
        }

        public ContextMenu addAll(Collection<? extends Action> actions) {
            for (Action action : actions) {
                this.add(action);
            }
            return this;
        }

        public ContextMenu add(Action a) {
            if (!Functions.isContextMenuVisible(a)) {
                return this;
            }
            StaplerRequest req = Stapler.getCurrentRequest();
            String text = a.getDisplayName();
            String base = Functions.getIconFilePath(a);
            if (base == null) {
                return this;
            }
            String icon = Stapler.getCurrentRequest().getContextPath() + (base.startsWith("images/") ? Functions.getResourcePath() : "") + '/' + base;
            String url = Functions.getActionUrl(req.findAncestor(ModelObject.class).getUrl(), a);
            return this.add(url, icon, text);
        }

        public ContextMenu add(String url, String icon, String text) {
            if (text != null && icon != null && url != null) {
                this.items.add(new MenuItem(url, icon, text));
            }
            return this;
        }

        public ContextMenu add(String url, String icon, String text, boolean post) {
            if (text != null && icon != null && url != null) {
                MenuItem item = new MenuItem(url, icon, text);
                item.post = post;
                this.items.add(item);
            }
            return this;
        }

        public ContextMenu add(String url, String icon, String text, boolean post, boolean requiresConfirmation) {
            if (text != null && icon != null && url != null) {
                MenuItem item = new MenuItem(url, icon, text);
                item.post = post;
                item.requiresConfirmation = requiresConfirmation;
                this.items.add(item);
            }
            return this;
        }

        @Restricted(value={DoNotUse.class})
        public ContextMenu addHeader(String title) {
            MenuItem item = new MenuItem().withDisplayName(title);
            item.header = true;
            return this.add(item);
        }

        public ContextMenu add(MenuItem item) {
            this.items.add(item);
            return this;
        }

        public ContextMenu add(Node n) {
            Computer c = n.toComputer();
            return this.add(new MenuItem().withDisplayName(n.getDisplayName()).withIconClass(c == null ? "icon-computer" : c.getIconClassName()).withContextRelativeUrl(n.getSearchUrl()));
        }

        public ContextMenu add(Computer c) {
            return this.add(new MenuItem().withDisplayName(c.getDisplayName()).withIconClass(c.getIconClassName()).withContextRelativeUrl(c.getUrl()));
        }

        public ContextMenu add(Job job) {
            return this.add(new MenuItem().withDisplayName(job.getDisplayName()).withIcon(job.getIconColor()).withUrl(job.getSearchUrl()));
        }

        public ContextMenu from(ModelObjectWithContextMenu self, StaplerRequest request, StaplerResponse response) throws JellyException, IOException {
            return this.from(self, request, response, "sidepanel");
        }

        public ContextMenu from(ModelObjectWithContextMenu self, StaplerRequest request, StaplerResponse response, String view) throws JellyException, IOException {
            WebApp webApp = WebApp.getCurrent();
            final Script s = (Script)((JellyClassTearOff)webApp.getMetaClass((Object)self).getTearOff(JellyClassTearOff.class)).findScript(view);
            if (s != null) {
                JellyFacet facet = (JellyFacet)webApp.getFacet(JellyFacet.class);
                request.setAttribute("taskTags", (Object)this);
                request.setAttribute("mode", (Object)"side-panel");
                facet.scriptInvoker.invokeScript(request, response, new Script(){

                    public Script compile() throws JellyException {
                        return this;
                    }

                    public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                        Functions.initPageVariables(context);
                        s.run(context, output);
                    }
                }, (Object)self, new XMLOutput((ContentHandler)new DefaultHandler()));
            } else if (self instanceof Actionable) {
                this.addAll(((Actionable)self).getAllActions());
            }
            return this;
        }
    }
}

