/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.ModifiableViewGroup;
import hudson.model.TransientViewActionFactory;
import hudson.model.View;
import hudson.model.ViewGroup;
import java.util.Collections;
import java.util.List;
import jenkins.model.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class NewViewLink
extends TransientViewActionFactory {
    @VisibleForTesting
    static final String ICON_FILE_NAME = "folder";
    @VisibleForTesting
    public static final String URL_NAME = "newView";

    @Override
    public List<Action> createFor(View v) {
        ViewGroup vg = v.getOwner();
        if (vg instanceof ModifiableViewGroup) {
            return Collections.singletonList(new NewViewLinkAction((ModifiableViewGroup)vg));
        }
        return Collections.emptyList();
    }

    private static class NewViewLinkAction
    implements Action {
        private ModifiableViewGroup target;

        private NewViewLinkAction(ModifiableViewGroup target) {
            this.target = target;
        }

        @Override
        public String getIconFileName() {
            if (this.hasPermission()) {
                return NewViewLink.ICON_FILE_NAME;
            }
            return null;
        }

        @Override
        public String getDisplayName() {
            return Messages.NewViewLink_NewView();
        }

        @Override
        public String getUrlName() {
            return "/" + this.target.getUrl() + NewViewLink.URL_NAME;
        }

        private boolean hasPermission() {
            return this.target.hasPermission(View.CREATE);
        }
    }
}

