/*
 * Decompiled with CFR 0.152.
 */
package jenkins.mvn;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import jenkins.mvn.Messages;
import jenkins.mvn.SettingsPathHelper;
import jenkins.mvn.SettingsProvider;
import jenkins.mvn.SettingsProviderDescriptor;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class FilePathSettingsProvider
extends SettingsProvider {
    private final String path;

    @DataBoundConstructor
    public FilePathSettingsProvider(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public FilePath supplySettings(AbstractBuild<?, ?> build, TaskListener listener) {
        if (StringUtils.isEmpty((String)this.path)) {
            return null;
        }
        try {
            return SettingsPathHelper.getSettings(build, listener, this.getPath());
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to prepare settings.xml", e);
        }
    }

    @Extension(ordinal=10.0)
    @Symbol(value={"filePath"})
    public static class DescriptorImpl
    extends SettingsProviderDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.FilePathSettingsProvider_DisplayName();
        }
    }
}

