/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.ExtensionPoint;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.triggers.SafeTimerTask;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.util.Timer;

@SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="The random is just used for an initial delay.")
public abstract class AperiodicWork
extends SafeTimerTask
implements ExtensionPoint {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final Random RANDOM = new Random();

    public abstract long getRecurrencePeriod();

    public abstract AperiodicWork getNewInstance();

    public long getInitialDelay() {
        long l = RANDOM.nextLong();
        if (l == Long.MIN_VALUE) {
            ++l;
        }
        return Math.abs(l) % this.getRecurrencePeriod();
    }

    @Override
    public final void doRun() throws Exception {
        this.doAperiodicRun();
        Timer.get().schedule(this.getNewInstance(), this.getRecurrencePeriod(), TimeUnit.MILLISECONDS);
    }

    @Initializer(after=InitMilestone.JOB_CONFIG_ADAPTED)
    public static void init() {
        ExtensionList<AperiodicWork> extensionList = AperiodicWork.all();
        extensionList.addListener(new AperiodicWorkExtensionListListener(extensionList));
        for (AperiodicWork p : AperiodicWork.all()) {
            AperiodicWork.scheduleAperiodWork(p);
        }
    }

    private static void scheduleAperiodWork(AperiodicWork ap) {
        Timer.get().schedule(ap, ap.getInitialDelay(), TimeUnit.MILLISECONDS);
    }

    protected abstract void doAperiodicRun();

    public static ExtensionList<AperiodicWork> all() {
        return ExtensionList.lookup(AperiodicWork.class);
    }

    private static class AperiodicWorkExtensionListListener
    extends ExtensionListListener {
        private final Set<AperiodicWork> registered = new HashSet<AperiodicWork>();

        AperiodicWorkExtensionListListener(ExtensionList<AperiodicWork> initiallyRegistered) {
            this.registered.addAll(initiallyRegistered);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange() {
            Set<AperiodicWork> set = this.registered;
            synchronized (set) {
                for (AperiodicWork p : AperiodicWork.all()) {
                    if (this.registered.contains(p)) continue;
                    AperiodicWork.scheduleAperiodWork(p);
                    this.registered.add(p);
                }
            }
        }
    }
}

