/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.listeners.RunListener;
import hudson.remoting.SingleLaneExecutorService;
import hudson.util.LogTaskListener;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.BackgroundGlobalBuildDiscarder;
import jenkins.model.GlobalBuildDiscarderConfiguration;
import jenkins.model.JobGlobalBuildDiscarderStrategy;
import jenkins.util.Timer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class GlobalBuildDiscarderListener
extends RunListener<Run> {
    private static final Logger LOGGER = Logger.getLogger(GlobalBuildDiscarderListener.class.getName());
    private final ExecutorService executor = new SingleLaneExecutorService((ExecutorService)Timer.get());

    @Override
    public void onFinalized(Run run) {
        this.executor.execute(() -> {
            Object job = run.getParent();
            try {
                ((Job)job).logRotate();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, () -> "Failed to rotate log for " + String.valueOf(run));
            }
            BackgroundGlobalBuildDiscarder.processJob(new LogTaskListener(LOGGER, Level.FINE), job, GlobalBuildDiscarderConfiguration.get().getConfiguredBuildDiscarders().stream().filter(s -> !(s instanceof JobGlobalBuildDiscarderStrategy)));
        });
    }

    @Restricted(value={DoNotUse.class})
    @VisibleForTesting
    public static void await() throws Exception {
        ExtensionList.lookupSingleton(GlobalBuildDiscarderListener.class).executor.submit(() -> {}).get();
    }
}

