/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.lib.support_log_formatter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SupportLogFormatter
extends Formatter {
    private static final ThreadLocal<SimpleDateFormat> threadLocalDateFormat = ThreadLocal.withInitial(() -> {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        return f;
    });
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    protected String formatTime(LogRecord record) {
        return threadLocalDateFormat.get().format(new Date(record.getMillis()));
    }

    @Override
    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="The exception wasn't thrown on our stack frame")
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.formatTime(record));
        builder.append(" [id=").append(record.getThreadID()).append("]");
        builder.append("\t").append(record.getLevel().getName()).append("\t");
        if (record.getSourceMethodName() != null) {
            sourceClass = record.getSourceClassName() == null ? record.getLoggerName() : record.getSourceClassName();
            builder.append(this.abbreviateClassName(sourceClass, 32)).append("#").append(record.getSourceMethodName());
        } else {
            sourceClass = record.getSourceClassName() == null ? record.getLoggerName() : record.getSourceClassName();
            builder.append(this.abbreviateClassName(sourceClass, 40));
        }
        String message = this.formatMessage(record);
        if (message != null) {
            builder.append(": ").append(message);
        }
        builder.append("\n");
        if (record.getThrown() != null) {
            try {
                builder.append(SupportLogFormatter.printThrowable(record.getThrown()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder.toString();
    }

    public String abbreviateClassName(String fqcn, int targetLength) {
        int i;
        if (fqcn == null) {
            return "-";
        }
        int fqcnLength = fqcn.length();
        if (fqcnLength < targetLength) {
            return fqcn;
        }
        int[] indexes = new int[16];
        int[] lengths = new int[17];
        int count = 0;
        int i2 = fqcn.indexOf(46);
        while (i2 != -1 && count < indexes.length) {
            indexes[count++] = i2;
            i2 = fqcn.indexOf(46, i2 + 1);
        }
        if (count == 0) {
            return fqcn;
        }
        StringBuilder buf = new StringBuilder(targetLength);
        int requiredSavings = fqcnLength - targetLength;
        for (i = 0; i < count; ++i) {
            int previous = i > 0 ? indexes[i - 1] : -1;
            int available = indexes[i] - previous - 1;
            int length = requiredSavings > 0 ? Math.min(available, 1) : available;
            requiredSavings -= available - length;
            lengths[i] = length + 1;
        }
        lengths[count] = fqcnLength - indexes[count - 1];
        for (i = 0; i <= count; ++i) {
            if (i == 0) {
                buf.append(fqcn, 0, lengths[i] - 1);
                continue;
            }
            buf.append(fqcn, indexes[i - 1], indexes[i - 1] + lengths[i]);
        }
        return buf.toString();
    }

    public static String printThrowable(Throwable t) {
        if (t == null) {
            return "No Exception details";
        }
        StringBuilder s = new StringBuilder();
        SupportLogFormatter.doPrintStackTrace(s, t, null, "", new HashSet<Throwable>());
        return s.toString();
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="TODO needs triage")
    private static void doPrintStackTrace(StringBuilder s, Throwable t, Throwable higher, String prefix, Set<Throwable> encountered) {
        int end;
        String suffix;
        if (!encountered.add(t)) {
            s.append("<cycle to ").append(t).append(">\n");
            return;
        }
        try {
            if (!t.getClass().getMethod("printStackTrace", PrintWriter.class).equals(Throwable.class.getMethod("printStackTrace", PrintWriter.class))) {
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                s.append(sw);
                return;
            }
        }
        catch (NoSuchMethodException x) {
            x.printStackTrace();
        }
        Throwable lower = t.getCause();
        if (lower != null) {
            SupportLogFormatter.doPrintStackTrace(s, lower, t, prefix, encountered);
        }
        for (Throwable suppressed : t.getSuppressed()) {
            s.append(prefix).append("Also:   ");
            SupportLogFormatter.doPrintStackTrace(s, suppressed, t, prefix + "\t", encountered);
        }
        if (lower != null) {
            s.append(prefix).append("Caused: ");
        }
        String summary = t.toString();
        if (lower != null && summary.endsWith(suffix = ": " + lower)) {
            summary = summary.substring(0, summary.length() - suffix.length());
        }
        s.append(summary).append(LINE_SEPARATOR);
        StackTraceElement[] trace = t.getStackTrace();
        if (higher != null) {
            int higherEnd;
            StackTraceElement[] higherTrace = higher.getStackTrace();
            for (end = trace.length; end > 0 && (higherEnd = end + higherTrace.length - trace.length) > 0 && higherTrace[higherEnd - 1].equals(trace[end - 1]); --end) {
            }
        }
        for (int i = 0; i < end; ++i) {
            s.append(prefix).append("\tat ").append(trace[i]).append(LINE_SEPARATOR);
        }
    }

    public static void printStackTrace(Throwable t, PrintWriter pw) {
        pw.println(SupportLogFormatter.printThrowable(t).trim());
    }

    public static void printStackTrace(Throwable t, PrintStream ps) {
        ps.println(SupportLogFormatter.printThrowable(t).trim());
    }
}

