/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Terminator;
import hudson.model.Computer;
import hudson.model.listeners.ItemListener;
import hudson.remoting.SingleLaneExecutorService;
import hudson.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionListener;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.MoreExecutors;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearBlockHoppingScanner;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.StepExecutionIterator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class FlowExecutionList
implements Iterable<FlowExecution> {
    public static final String EXECUTIONS_SUSPENDED = "FlowExecutionList.EXECUTIONS_SUSPENDED";
    public static final String LIST_SAVED = "FlowExecutionList.LIST_SAVED";
    private volatile transient boolean resumptionComplete;
    private static final Logger LOGGER = Logger.getLogger(FlowExecutionList.class.getName());

    public FlowExecutionList() {
        ((Storage)ExtensionList.lookupFirst(Storage.class)).load();
    }

    @Override
    public Iterator<FlowExecution> iterator() {
        return ((Storage)ExtensionList.lookupFirst(Storage.class)).iterator();
    }

    public synchronized void register(FlowExecutionOwner self) {
        ((Storage)ExtensionList.lookupFirst(Storage.class)).register(self);
    }

    public synchronized void unregister(FlowExecutionOwner self) {
        ((Storage)ExtensionList.lookupFirst(Storage.class)).unregister(self);
    }

    public static FlowExecutionList get() {
        return (FlowExecutionList)ExtensionList.lookupSingleton(FlowExecutionList.class);
    }

    @Restricted(value={Beta.class})
    public boolean isResumptionComplete() {
        return this.resumptionComplete;
    }

    private void resume() {
        ((Storage)ExtensionList.lookupFirst(Storage.class)).resume();
        this.resumptionComplete = true;
    }

    @Restricted(value={DoNotUse.class})
    @Terminator(requires={"FlowExecutionList.EXECUTIONS_SUSPENDED"}, attains={"FlowExecutionList.LIST_SAVED"})
    public static void saveAll() throws InterruptedException {
        LOGGER.fine("ensuring all executions are saved");
        ((Storage)ExtensionList.lookupFirst(Storage.class)).shutDown();
    }

    @Restricted(value={Beta.class})
    public static interface Storage
    extends ExtensionPoint {
        public Iterator<FlowExecution> iterator();

        public void register(FlowExecutionOwner var1);

        public void unregister(FlowExecutionOwner var1);

        public boolean contains(FlowExecutionOwner var1);

        public void load();

        public void resume();

        public void shutDown() throws InterruptedException;
    }

    private static final class ParallelResumer {
        private final Runnable onCompletion;
        private final Map<FlowNode, StepExecution> nodes = new HashMap<FlowNode, StepExecution>();
        private final Set<FlowNode> processing = new HashSet<FlowNode>();
        private final Map<FlowNode, FlowNode> enclosing = new HashMap<FlowNode, FlowNode>();

        ParallelResumer(Collection<StepExecution> executions, Runnable onCompletion) {
            FlowNode n;
            this.onCompletion = onCompletion;
            for (StepExecution stepExecution : executions) {
                try {
                    n = (FlowNode)((Object)stepExecution.getContext().get(FlowNode.class));
                    if (n != null) {
                        this.nodes.put(n, stepExecution);
                        continue;
                    }
                    LOGGER.warning(() -> "Could not find FlowNode for " + String.valueOf(se) + " so it will not be resumed");
                }
                catch (IOException | InterruptedException x) {
                    LOGGER.log(Level.WARNING, "Could not look up FlowNode for " + String.valueOf(stepExecution) + " so it will not be resumed", x);
                }
            }
            for (Map.Entry entry : this.nodes.entrySet()) {
                n = (FlowNode)((Object)entry.getKey());
                try {
                    LinearBlockHoppingScanner scanner = new LinearBlockHoppingScanner();
                    scanner.setup(n);
                    for (FlowNode parent : scanner) {
                        if (parent == n || !this.nodes.containsKey((Object)parent)) continue;
                        this.enclosing.put(n, parent);
                    }
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, x, () -> "Unable to compute enclosing blocks for " + String.valueOf((Object)n) + ", so " + String.valueOf(entry.getValue()) + " might not resume successfully");
                }
            }
        }

        synchronized void run() {
            FlowNode n;
            if (Jenkins.get().isTerminating()) {
                LOGGER.fine("Skipping step resumption during shutdown");
                return;
            }
            if (Jenkins.get().getInitLevel() != InitMilestone.COMPLETED || Jenkins.get().isQuietingDown()) {
                LOGGER.fine("Waiting to resume step until Jenkins completes startup and is not in quiet mode");
                Timer.get().schedule(this::run, 100L, TimeUnit.MILLISECONDS);
                return;
            }
            LOGGER.fine(() -> "Checking status with nodes=" + String.valueOf(this.nodes) + " enclosing=" + String.valueOf(this.enclosing) + " processing=" + String.valueOf(this.processing));
            if (this.nodes.isEmpty()) {
                if (this.processing.isEmpty()) {
                    LOGGER.fine("Done");
                    this.onCompletion.run();
                }
                return;
            }
            HashMap<FlowNode, StepExecution> ready = new HashMap<FlowNode, StepExecution>();
            for (Map.Entry<FlowNode, StepExecution> entry : this.nodes.entrySet()) {
                n = entry.getKey();
                FlowNode parent = this.enclosing.get((Object)n);
                if (parent != null && this.nodes.containsKey((Object)parent)) continue;
                ready.put(n, entry.getValue());
            }
            LOGGER.fine(() -> "Ready to resume: " + String.valueOf(ready));
            this.nodes.keySet().removeAll(ready.keySet());
            for (Map.Entry<FlowNode, Object> entry : ready.entrySet()) {
                n = entry.getKey();
                StepExecution exec = (StepExecution)entry.getValue();
                this.processing.add(n);
                Computer.threadPoolForRemoting.submit(() -> {
                    LOGGER.fine(() -> "About to resume " + String.valueOf((Object)n) + " ~ " + String.valueOf(exec));
                    try {
                        exec.onResume();
                    }
                    catch (Throwable x) {
                        exec.getContext().onFailure(x);
                    }
                    LOGGER.fine(() -> "Finished resuming " + String.valueOf((Object)n) + " ~ " + String.valueOf(exec));
                    ParallelResumer parallelResumer = this;
                    synchronized (parallelResumer) {
                        this.processing.remove((Object)n);
                        this.run();
                    }
                });
            }
        }
    }

    @Extension
    public static class ResumeStepExecutionListener
    extends FlowExecutionListener {
        @Override
        public void onResumed(final @NonNull FlowExecution e) {
            Futures.addCallback(e.getCurrentExecutions(false), (FutureCallback)new FutureCallback<List<StepExecution>>(){

                public void onSuccess(@NonNull List<StepExecution> result) {
                    if (e.isComplete()) {
                        return;
                    }
                    FlowExecutionOwner owner = e.getOwner();
                    if (!((Storage)ExtensionList.lookupFirst(Storage.class)).contains(owner)) {
                        LOGGER.warning(() -> "Resuming " + String.valueOf(owner) + ", which is missing from FlowExecutionList, so registering it now");
                        FlowExecutionList.get().register(owner);
                    }
                    LOGGER.log(Level.FINE, "Will resume {0}", result);
                    new ParallelResumer(result, e::afterStepExecutionsResumed).run();
                }

                public void onFailure(@NonNull Throwable t) {
                    if (t instanceof CancellationException) {
                        LOGGER.log(Level.FINE, "Cancelled load of " + String.valueOf(e), t);
                    } else {
                        LOGGER.log(Level.WARNING, "Failed to load " + String.valueOf(e), t);
                    }
                    e.afterStepExecutionsResumed();
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    @Extension
    public static class StepExecutionIteratorImpl
    extends StepExecutionIterator {
        public ListenableFuture<?> accept(Consumer<StepExecution> c) {
            ArrayList<ListenableFuture> all = new ArrayList<ListenableFuture>();
            for (FlowExecution e : FlowExecutionList.get()) {
                ListenableFuture<List<StepExecution>> execs = e.getCurrentExecutions(false);
                ListenableFuture results = Futures.transform(execs, result -> {
                    for (StepExecution se : result) {
                        try {
                            c.accept(se);
                        }
                        catch (RuntimeException x) {
                            LOGGER.log(Level.WARNING, null, x);
                        }
                    }
                    return null;
                }, (Executor)MoreExecutors.directExecutor());
                ListenableFuture resultsWithWarningsLogged = Futures.catching((ListenableFuture)results, Throwable.class, t -> {
                    LOGGER.log(Level.WARNING, null, (Throwable)t);
                    return null;
                }, (Executor)MoreExecutors.directExecutor());
                all.add(resultsWithWarningsLogged);
            }
            return Futures.allAsList(all);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Extension(ordinal=-1000.0)
    public static final class DefaultStorage
    implements Storage {
        private final CopyOnWriteList<FlowExecutionOwner> runningTasks = new CopyOnWriteList();
        private final SingleLaneExecutorService executor = new SingleLaneExecutorService((ExecutorService)Timer.get());
        private XmlFile configFile;

        @Override
        public Iterator<FlowExecution> iterator() {
            return new AbstractIterator<FlowExecution>(){
                final Iterator<FlowExecutionOwner> base;
                {
                    this.base = runningTasks.iterator();
                }

                protected FlowExecution computeNext() {
                    while (this.base.hasNext()) {
                        FlowExecutionOwner o = this.base.next();
                        try {
                            FlowExecution e = o.get();
                            if (e.isComplete()) continue;
                            return e;
                        }
                        catch (Throwable e) {
                            LOGGER.log(Level.FINE, "Failed to load " + String.valueOf(o) + ". Unregistering", e);
                            this.unregister(o);
                        }
                    }
                    return (FlowExecution)this.endOfData();
                }
            };
        }

        @Override
        public void register(FlowExecutionOwner o) {
            if (this.runningTasks.contains((Object)o)) {
                LOGGER.log(Level.WARNING, "{0} was already in the list: {1}", new Object[]{o, this.runningTasks.getView()});
            } else {
                this.runningTasks.add((Object)o);
                this.saveLater();
            }
        }

        @Override
        public void unregister(FlowExecutionOwner o) {
            if (this.runningTasks.remove((Object)o)) {
                LOGGER.log(Level.FINE, "unregistered {0}", new Object[]{o});
                this.saveLater();
            } else {
                LOGGER.log(Level.WARNING, "{0} was not in the list to begin with: {1}", new Object[]{o, this.runningTasks.getView()});
            }
        }

        @Override
        public boolean contains(FlowExecutionOwner o) {
            return this.runningTasks.contains((Object)o);
        }

        @Override
        public void load() {
            XmlFile cf = this.configFile();
            if (cf == null) {
                return;
            }
            if (cf.exists()) {
                try {
                    this.runningTasks.replaceBy((Collection)((List)cf.read()));
                    LOGGER.log(Level.FINE, "loaded: {0}", this.runningTasks);
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "ignoring broken " + String.valueOf(cf), x);
                }
            }
        }

        @Override
        public void resume() {
            boolean needSave = false;
            Iterator it = this.runningTasks.iterator();
            while (it.hasNext()) {
                FlowExecutionOwner owner = (FlowExecutionOwner)it.next();
                try {
                    FlowExecution exec = owner.get();
                    LOGGER.fine(() -> "eagerly loaded " + String.valueOf(exec));
                    if (!exec.isComplete()) continue;
                    LOGGER.fine(() -> "unregistering completed " + String.valueOf(exec));
                    it.remove();
                    needSave = true;
                }
                catch (IOException x) {
                    LOGGER.log(Level.FINE, x, () -> "failed to load " + String.valueOf(owner) + "; unregistering");
                    it.remove();
                    needSave = true;
                }
            }
            if (needSave) {
                this.saveLater();
            }
        }

        @Override
        public void shutDown() throws InterruptedException {
            this.executor.shutdown();
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }

        private synchronized void saveLater() {
            ArrayList<FlowExecutionOwner> copy = new ArrayList<FlowExecutionOwner>(this.runningTasks.getView());
            LOGGER.log(Level.FINE, "scheduling save of {0}", copy);
            try {
                this.executor.submit(() -> this.save(copy));
            }
            catch (RejectedExecutionException x) {
                LOGGER.log(Level.FINE, "could not schedule save, perhaps because Jenkins is shutting down; saving immediately", x);
                this.save(copy);
            }
        }

        private void save(List<FlowExecutionOwner> copy) {
            XmlFile cf = this.configFile();
            LOGGER.log(Level.FINE, "saving {0} to {1}", new Object[]{copy, cf});
            if (cf == null) {
                return;
            }
            try {
                cf.write(copy);
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }

        @CheckForNull
        private synchronized XmlFile configFile() {
            Jenkins j;
            if (this.configFile == null && (j = Jenkins.getInstanceOrNull()) != null) {
                this.configFile = new XmlFile(new File(j.getRootDir(), FlowExecutionList.class.getName() + ".xml"));
            }
            return this.configFile;
        }
    }

    @Extension
    public static class ItemListenerImpl
    extends ItemListener {
        public void onLoaded() {
            Timer.get().submit(FlowExecutionList.get()::resume);
        }
    }
}

