/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.ChannelClosedException;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.util.Timer;

final class GCFlushedOutputStream
extends FilterOutputStream {
    private static final Logger LOGGER = Logger.getLogger(GCFlushedOutputStream.class.getName());

    GCFlushedOutputStream(OutputStream out) {
        super(out);
        FlushRef.register(this, out);
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public String toString() {
        return "GCFlushedOutputStream[" + String.valueOf(this.out) + "]";
    }

    private static boolean isClosedChannelException(Throwable t) {
        if (t instanceof ClosedChannelException) {
            return true;
        }
        if (t instanceof ChannelClosedException) {
            return true;
        }
        if (t instanceof EOFException) {
            return true;
        }
        if (t == null) {
            return false;
        }
        return GCFlushedOutputStream.isClosedChannelException(t.getCause()) || Stream.of(t.getSuppressed()).anyMatch(GCFlushedOutputStream::isClosedChannelException);
    }

    private static final class FlushRef
    extends PhantomReference<GCFlushedOutputStream> {
        private static final ReferenceQueue<GCFlushedOutputStream> rq = new ReferenceQueue();
        private final OutputStream out;

        static void register(GCFlushedOutputStream fos, OutputStream out) {
            new FlushRef(fos, out, rq).enqueue();
        }

        private FlushRef(GCFlushedOutputStream fos, OutputStream out, ReferenceQueue<GCFlushedOutputStream> rq) {
            super(fos, rq);
            this.out = out;
        }

        static {
            Timer.get().scheduleWithFixedDelay(() -> {
                FlushRef ref;
                while ((ref = (FlushRef)rq.poll()) != null) {
                    LOGGER.log(Level.FINE, "flushing {0}", ref.out);
                    try {
                        ref.out.flush();
                    }
                    catch (IOException x) {
                        LOGGER.log(GCFlushedOutputStream.isClosedChannelException(x) ? Level.FINE : Level.WARNING, null, x);
                    }
                }
            }, 0L, 10L, TimeUnit.SECONDS);
        }
    }
}

