/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GitList
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GitList(String repoUrl) {
        super(repoUrl);
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "commit/" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        return this.getDiffLinkRegardlessOfEditType(path);
    }

    private URL getDiffLinkRegardlessOfEditType(GitChangeSet.Path path) throws IOException {
        return GitList.encodeURL(new URL(this.getChangeSetLink(path.getChangeSet()), "#" + (this.getIndexOfPath(path) + 1)));
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLinkRegardlessOfEditType(path);
        }
        String spec = "blob/" + path.getChangeSet().getId() + "/" + path.getPath();
        URL url = this.getUrl();
        return GitList.encodeURL(new URL(url, url.getPath() + spec));
    }

    @Extension
    public static class GitListDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "gitlist";
        }

        public GitList newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (GitList)((Object)req.bindJSON(GitList.class, jsonObject));
        }
    }
}

