/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git.traits;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.plugins.git.traits.Messages;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DiscoverOtherRefsTrait
extends SCMSourceTrait {
    private final String ref;
    private String nameMapping;

    @DataBoundConstructor
    public DiscoverOtherRefsTrait(String ref) {
        if (StringUtils.isEmpty((String)ref)) {
            throw new IllegalArgumentException("ref can not be empty");
        }
        this.ref = StringUtils.removeStart((String)StringUtils.removeStart((String)ref, (String)"refs/"), (String)"/");
        this.setDefaultNameMapping();
    }

    public DiscoverOtherRefsTrait(String ref, String nameMapping) {
        this(ref);
        this.setNameMapping(nameMapping);
    }

    public String getRef() {
        return this.ref;
    }

    String getFullRefSpec() {
        return "+refs/" + this.ref + ':' + "refs/remotes/" + "@{remote}" + '/' + this.ref;
    }

    public String getNameMapping() {
        return this.nameMapping;
    }

    @DataBoundSetter
    public void setNameMapping(String nameMapping) {
        if (StringUtils.isEmpty((String)nameMapping)) {
            this.setDefaultNameMapping();
        } else {
            this.nameMapping = nameMapping;
        }
    }

    private void setDefaultNameMapping() {
        this.nameMapping = null;
        String[] paths = this.ref.split("/");
        for (int i = 0; i < paths.length; ++i) {
            if (!"*".equals(paths[i]) || i <= 0) continue;
            this.nameMapping = paths[i - 1] + "-@{1}";
            break;
        }
        if (StringUtils.isEmpty((String)this.nameMapping)) {
            this.nameMapping = this.ref.contains("*") ? "other-@{1}" : "other-ref";
        }
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GitSCMSourceContext c = (GitSCMSourceContext)context;
        c.withRefSpec(this.getFullRefSpec());
        c.wantOtherRef(new GitSCMSourceContext.RefNameMapping(this.ref, this.nameMapping));
    }

    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.DiscoverOtherRefsTrait_displayName();
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitSCMSource.class;
        }
    }
}

