/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graph;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.BallColor;
import hudson.model.Result;
import hudson.model.Saveable;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class FlowNode
extends Actionable
implements Saveable {
    private transient List<FlowNode> parents;
    private final List<String> parentIds;
    private String id;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="this is a copy-on-write array so synchronization isn't needed between reader & writer")
    private transient CopyOnWriteArrayList<Action> actions = new CopyOnWriteArrayList();
    private final transient FlowExecution exec;
    private static final Logger LOGGER = Logger.getLogger(FlowNode.class.getName());

    protected FlowNode(FlowExecution exec, String id, List<FlowNode> parents) {
        this.id = id;
        this.exec = exec;
        this.parents = ImmutableList.copyOf(parents);
        this.parentIds = this.ids();
    }

    protected FlowNode(FlowExecution exec, String id, FlowNode ... parents) {
        this.id = id;
        this.exec = exec;
        this.parents = ImmutableList.copyOf((Object[])parents);
        this.parentIds = this.ids();
    }

    private List<String> ids() {
        ArrayList<String> ids = new ArrayList<String>(this.parents.size());
        for (FlowNode n : this.parents) {
            ids.add(n.id);
        }
        return ids;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.id != null) {
            this.id = this.id.intern();
        }
        if (this.parentIds != null) {
            for (int i = 0; i < this.parentIds.size(); ++i) {
                this.parentIds.set(i, this.parentIds.get(i).intern());
            }
        }
        return this;
    }

    @Deprecated
    public final boolean isRunning() {
        return this.getExecution().isCurrentHead(this);
    }

    @Exported(name="running")
    public final boolean isActive() {
        return this.getExecution().isActive(this);
    }

    @CheckForNull
    public final ErrorAction getError() {
        return this.getPersistentAction(ErrorAction.class);
    }

    @NonNull
    public FlowExecution getExecution() {
        return this.exec;
    }

    @NonNull
    public List<FlowNode> getParents() {
        if (this.parents == null) {
            this.parents = this.loadParents(this.parentIds);
        }
        return this.parents;
    }

    @NonNull
    private List<FlowNode> loadParents(List<String> parentIds) {
        try {
            if (parentIds.size() == 1) {
                return Collections.singletonList(this.exec.getNode(parentIds.get(0)));
            }
            ArrayList<FlowNode> _parents = new ArrayList<FlowNode>(parentIds.size());
            for (String parentId : parentIds) {
                _parents.add(this.exec.getNode(parentId));
            }
            return _parents;
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "failed to load parents of " + this.id, x);
            return Collections.emptyList();
        }
    }

    @CheckForNull
    public String getEnclosingId() {
        BlockStartNode enclosing = this.exec.findEnclosingBlockStart(this);
        return enclosing != null ? enclosing.getId() : null;
    }

    @NonNull
    public List<? extends BlockStartNode> getEnclosingBlocks() {
        return this.exec.findAllEnclosingBlockStarts(this);
    }

    @NonNull
    public Iterable<BlockStartNode> iterateEnclosingBlocks() {
        return this.exec.iterateEnclosingBlocks(this);
    }

    @NonNull
    public List<String> getAllEnclosingIds() {
        List<? extends BlockStartNode> nodes = this.getEnclosingBlocks();
        ArrayList<String> output = new ArrayList<String>(nodes.size());
        for (FlowNode flowNode : nodes) {
            output.add(flowNode.getId());
        }
        return output;
    }

    @Restricted(value={DoNotUse.class})
    @Exported(name="parents")
    @NonNull
    public List<String> getParentIds() {
        if (this.parentIds != null) {
            return Collections.unmodifiableList(this.parentIds);
        }
        ArrayList<String> ids = new ArrayList<String>(this.parents.size());
        for (FlowNode parent : this.getParents()) {
            ids.add(parent.getId());
        }
        return ids;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    public final String getSearchUrl() {
        return this.getId();
    }

    @Exported
    public String getDisplayName() {
        LabelAction a = this.getPersistentAction(LabelAction.class);
        if (a != null) {
            return a.getDisplayName();
        }
        return this.getTypeDisplayName();
    }

    public String getDisplayFunctionName() {
        String functionName = this.getTypeFunctionName();
        if (functionName == null) {
            return this.getDisplayName();
        }
        LabelAction a = this.getPersistentAction(LabelAction.class);
        if (a != null) {
            return functionName + " (" + a.getDisplayName() + ")";
        }
        return functionName;
    }

    @Exported
    public BallColor getIconColor() {
        ErrorAction error = this.getError();
        WarningAction warning = this.getPersistentAction(WarningAction.class);
        BallColor c = null;
        c = error != null ? (error.getError() instanceof FlowInterruptedException ? FlowNode.resultToBallColor(((FlowInterruptedException)error.getError()).getResult()) : BallColor.RED) : (warning != null ? FlowNode.resultToBallColor(warning.getResult()) : BallColor.BLUE);
        if (this.isActive()) {
            c = c.anime();
        }
        return c;
    }

    private static BallColor resultToBallColor(@NonNull Result result) {
        if (result == Result.SUCCESS) {
            return BallColor.BLUE;
        }
        if (result == Result.UNSTABLE) {
            return BallColor.YELLOW;
        }
        if (result == Result.FAILURE) {
            return BallColor.RED;
        }
        if (result == Result.NOT_BUILT) {
            return BallColor.NOTBUILT;
        }
        if (result == Result.ABORTED) {
            return BallColor.ABORTED;
        }
        return BallColor.GREY;
    }

    protected abstract String getTypeDisplayName();

    protected String getTypeFunctionName() {
        return this.getDisplayName();
    }

    @Exported
    public String getUrl() throws IOException {
        return this.getExecution().getUrl() + "node/" + this.getId() + '/';
    }

    protected synchronized void setActions(List<Action> actions) {
        this.actions = new CopyOnWriteArrayList<Action>(actions);
    }

    @CheckForNull
    public final <T extends Action> T getPersistentAction(@NonNull Class<T> type) {
        this.loadActions();
        for (Action a : this.actions) {
            if (!type.isInstance(a)) continue;
            return (T)((Action)type.cast(a));
        }
        return null;
    }

    private <T extends Action> T getMaybeTransientAction(Class<T> type) {
        for (Action a : this.getAllActions()) {
            if (!type.isInstance(a)) continue;
            return (T)((Action)type.cast(a));
        }
        return null;
    }

    @CheckForNull
    public <T extends Action> T getAction(Class<T> type) {
        if (PersistentAction.class.isAssignableFrom(type)) {
            return this.getPersistentAction(type);
        }
        return this.getMaybeTransientAction(type);
    }

    private synchronized void loadActions() {
        if (this.actions != null) {
            return;
        }
        try {
            this.actions = new CopyOnWriteArrayList<Action>(this.exec.loadActions(this));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load actions for FlowNode id=" + this.id, e);
            this.actions = new CopyOnWriteArrayList();
        }
    }

    @Exported
    @NonNull
    @SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="CopyOnWrite ArrayList, and field load & modification is synchronized")
    public List<Action> getActions() {
        this.loadActions();
        return new AbstractList<Action>(){

            @Override
            public Action get(int index) {
                return (Action)FlowNode.this.actions.get(index);
            }

            @Override
            public void add(int index, Action element) {
                FlowNode.this.actions.add(index, element);
                FlowNode.this.persistSafe();
            }

            @Override
            public Iterator<Action> iterator() {
                return FlowNode.this.actions.iterator();
            }

            @Override
            public Action remove(int index) {
                Action old = (Action)FlowNode.this.actions.remove(index);
                FlowNode.this.persistSafe();
                return old;
            }

            @Override
            public Action set(int index, Action element) {
                Action old = FlowNode.this.actions.set(index, element);
                FlowNode.this.persistSafe();
                return old;
            }

            @Override
            public int size() {
                return FlowNode.this.actions.size();
            }

            @Override
            public boolean removeAll(@NonNull Collection<?> c) {
                boolean changed = FlowNode.this.actions.removeAll(c);
                if (changed) {
                    FlowNode.this.persistSafe();
                }
                return changed;
            }
        };
    }

    public void save() throws IOException {
        this.exec.saveActions(this, this.actions);
    }

    private void persistSafe() {
        try {
            this.save();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "failed to save actions for FlowNode id=" + this.id, e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FlowNode) {
            FlowNode that = (FlowNode)((Object)obj);
            return this.id.equals(that.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[id=" + this.id + ", exec=" + this.exec + "]";
    }
}

