/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.console.AnnotatedLargeText;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.BrokenLogStorage;
import org.jenkinsci.plugins.workflow.log.FileLogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorageFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public interface LogStorage {
    @NonNull
    public BuildListener overallListener() throws IOException, InterruptedException;

    @NonNull
    public TaskListener nodeListener(@NonNull FlowNode var1) throws IOException, InterruptedException;

    @NonNull
    public AnnotatedLargeText<FlowExecutionOwner.Executable> overallLog(@NonNull FlowExecutionOwner.Executable var1, boolean var2);

    @NonNull
    public static String startStep(@NonNull String id) {
        return "<span class=\"pipeline-node-" + id + "\">";
    }

    @NonNull
    public static String endStep() {
        return "</span>";
    }

    @NonNull
    public AnnotatedLargeText<FlowNode> stepLog(@NonNull FlowNode var1, boolean var2);

    @Deprecated
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="silly rule")
    @NonNull
    default public File getLogFile(@NonNull FlowExecutionOwner.Executable build, boolean complete) {
        try {
            AnnotatedLargeText<FlowExecutionOwner.Executable> logText = this.overallLog(build, complete);
            FlowExecutionOwner owner = build.asFlowExecutionOwner();
            File f = File.createTempFile("deprecated", ".log", owner != null ? owner.getRootDir() : null);
            f.deleteOnExit();
            try (FileOutputStream os = new FileOutputStream(f);){
                long pos2;
                long pos = 0L;
                while ((pos2 = logText.writeRawLogTo(pos, (OutputStream)os)) > pos) {
                    pos = pos2;
                }
            }
            return f;
        }
        catch (Exception x) {
            Logger.getLogger(LogStorage.class.getName()).log(Level.WARNING, null, x);
            if (build instanceof Run) {
                return new File(((Run)build).getRootDir(), "log");
            }
            return new File("broken.log");
        }
    }

    @NonNull
    public static LogStorage of(@NonNull FlowExecutionOwner b) {
        try {
            for (LogStorageFactory factory : ExtensionList.lookup(LogStorageFactory.class)) {
                LogStorage storage = factory.forBuild(b);
                if (storage == null) continue;
                return storage;
            }
            return FileLogStorage.forFile(new File(b.getRootDir(), "log"));
        }
        catch (Exception x) {
            return new BrokenLogStorage(x);
        }
    }
}

