/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Terminator;
import hudson.model.Computer;
import hudson.model.Queue;
import hudson.model.listeners.ItemListener;
import hudson.remoting.SingleLaneExecutorService;
import hudson.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionListener;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.MoreExecutors;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearBlockHoppingScanner;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.StepExecutionIterator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;

@Extension
public class FlowExecutionList
implements Iterable<FlowExecution> {
    public static final String EXECUTIONS_SUSPENDED = "FlowExecutionList.EXECUTIONS_SUSPENDED";
    public static final String LIST_SAVED = "FlowExecutionList.LIST_SAVED";
    private final CopyOnWriteList<FlowExecutionOwner> runningTasks = new CopyOnWriteList();
    private final SingleLaneExecutorService executor = new SingleLaneExecutorService((ExecutorService)Timer.get());
    private XmlFile configFile;
    private volatile transient boolean resumptionComplete;
    private static final Logger LOGGER = Logger.getLogger(FlowExecutionList.class.getName());

    public FlowExecutionList() {
        this.load();
    }

    @Override
    public Iterator<FlowExecution> iterator() {
        return new AbstractIterator<FlowExecution>(){
            final Iterator<FlowExecutionOwner> base;
            {
                this.base = FlowExecutionList.this.runningTasks.iterator();
            }

            protected FlowExecution computeNext() {
                while (this.base.hasNext()) {
                    FlowExecutionOwner o = this.base.next();
                    try {
                        FlowExecution e = o.get();
                        if (e.isComplete()) continue;
                        return e;
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.FINE, "Failed to load " + o + ". Unregistering", e);
                        FlowExecutionList.this.unregister(o);
                    }
                }
                return (FlowExecution)this.endOfData();
            }
        };
    }

    @CheckForNull
    private synchronized XmlFile configFile() {
        Jenkins j;
        if (this.configFile == null && (j = Jenkins.getInstanceOrNull()) != null) {
            String id = SystemProperties.getString((String)(Queue.class.getName() + ".id"));
            File f = id != null ? new File(Jenkins.get().getRootDir(), FlowExecutionList.class.getName() + "/" + id + ".xml") : new File(j.getRootDir(), FlowExecutionList.class.getName() + ".xml");
            this.configFile = new XmlFile(f);
        }
        return this.configFile;
    }

    private synchronized void load() {
        XmlFile cf = this.configFile();
        if (cf == null) {
            return;
        }
        if (cf.exists()) {
            try {
                this.runningTasks.replaceBy((Collection)((List)cf.read()));
                LOGGER.log(Level.FINE, "loaded: {0}", this.runningTasks);
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "ignoring broken " + cf, x);
            }
        }
    }

    public synchronized void register(FlowExecutionOwner self) {
        if (this.runningTasks.contains((Object)self)) {
            LOGGER.log(Level.WARNING, "{0} was already in the list: {1}", new Object[]{self, this.runningTasks.getView()});
        } else {
            this.runningTasks.add((Object)self);
            this.saveLater();
        }
    }

    public synchronized void unregister(FlowExecutionOwner self) {
        if (this.runningTasks.remove((Object)self)) {
            LOGGER.log(Level.FINE, "unregistered {0}", new Object[]{self});
            this.saveLater();
        } else {
            LOGGER.log(Level.WARNING, "{0} was not in the list to begin with: {1}", new Object[]{self, this.runningTasks.getView()});
        }
    }

    private synchronized void saveLater() {
        ArrayList<FlowExecutionOwner> copy = new ArrayList<FlowExecutionOwner>(this.runningTasks.getView());
        LOGGER.log(Level.FINE, "scheduling save of {0}", copy);
        try {
            this.executor.submit(() -> this.save(copy));
        }
        catch (RejectedExecutionException x) {
            LOGGER.log(Level.FINE, "could not schedule save, perhaps because Jenkins is shutting down; saving immediately", x);
            this.save(copy);
        }
    }

    private void save(List<FlowExecutionOwner> copy) {
        XmlFile cf = this.configFile();
        LOGGER.log(Level.FINE, "saving {0} to {1}", new Object[]{copy, cf});
        if (cf == null) {
            return;
        }
        try {
            cf.write(copy);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    public static FlowExecutionList get() {
        FlowExecutionList l = (FlowExecutionList)ExtensionList.lookup(FlowExecutionList.class).get(FlowExecutionList.class);
        if (l == null) {
            l = new FlowExecutionList();
        }
        return l;
    }

    @Restricted(value={Beta.class})
    public boolean isResumptionComplete() {
        return this.resumptionComplete;
    }

    private void resume() {
        boolean needSave = false;
        Iterator it = this.runningTasks.iterator();
        while (it.hasNext()) {
            FlowExecutionOwner o = (FlowExecutionOwner)it.next();
            try {
                FlowExecution e = o.get();
                LOGGER.log(Level.FINE, "Eagerly loaded {0}", e);
                if (!e.isComplete()) continue;
                LOGGER.log(Level.FINE, "Unregistering completed " + o, e);
                it.remove();
                needSave = true;
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Failed to load " + o + ". Unregistering", ex);
                it.remove();
                needSave = true;
            }
        }
        if (needSave) {
            this.saveLater();
        }
        this.resumptionComplete = true;
    }

    @Restricted(value={DoNotUse.class})
    @Terminator(requires={"FlowExecutionList.EXECUTIONS_SUSPENDED"}, attains={"FlowExecutionList.LIST_SAVED"})
    public static void saveAll() throws InterruptedException {
        LOGGER.fine("ensuring all executions are saved");
        for (FlowExecutionOwner owner : FlowExecutionList.get().runningTasks.getView()) {
            try {
                owner.notifyShutdown();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Error shutting down task", ex);
            }
        }
        SingleLaneExecutorService executor = FlowExecutionList.get().executor;
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.MINUTES);
    }

    private static final class ParallelResumer {
        private final Runnable onCompletion;
        private final Map<FlowNode, StepExecution> nodes = new HashMap<FlowNode, StepExecution>();
        private final Set<FlowNode> processing = new HashSet<FlowNode>();
        private final Map<FlowNode, FlowNode> enclosing = new HashMap<FlowNode, FlowNode>();

        ParallelResumer(Collection<StepExecution> executions, Runnable onCompletion) {
            this.onCompletion = onCompletion;
            for (StepExecution se : executions) {
                try {
                    FlowNode n = (FlowNode)((Object)se.getContext().get(FlowNode.class));
                    if (n != null) {
                        this.nodes.put(n, se);
                        continue;
                    }
                    LOGGER.warning(() -> "Could not find FlowNode for " + se + " so it will not be resumed");
                }
                catch (IOException | InterruptedException x) {
                    LOGGER.log(Level.WARNING, "Could not look up FlowNode for " + se + " so it will not be resumed", x);
                }
            }
            block3: for (FlowNode n : this.nodes.keySet()) {
                LinearBlockHoppingScanner scanner = new LinearBlockHoppingScanner();
                scanner.setup(n);
                for (FlowNode parent : scanner) {
                    if (parent == n || !this.nodes.containsKey((Object)parent)) continue;
                    this.enclosing.put(n, parent);
                    continue block3;
                }
            }
        }

        synchronized void run() {
            FlowNode n;
            if (Jenkins.get().isTerminating()) {
                LOGGER.fine("Skipping step resumption during shutdown");
                return;
            }
            if (Jenkins.get().getInitLevel() != InitMilestone.COMPLETED || Jenkins.get().isQuietingDown()) {
                LOGGER.fine("Waiting to resume step until Jenkins completes startup and is not in quiet mode");
                Timer.get().schedule(this::run, 100L, TimeUnit.MILLISECONDS);
                return;
            }
            LOGGER.fine(() -> "Checking status with nodes=" + this.nodes + " enclosing=" + this.enclosing + " processing=" + this.processing);
            if (this.nodes.isEmpty()) {
                if (this.processing.isEmpty()) {
                    LOGGER.fine("Done");
                    this.onCompletion.run();
                }
                return;
            }
            HashMap<FlowNode, StepExecution> ready = new HashMap<FlowNode, StepExecution>();
            for (Map.Entry<FlowNode, StepExecution> entry : this.nodes.entrySet()) {
                n = entry.getKey();
                FlowNode parent = this.enclosing.get((Object)n);
                if (parent != null && this.nodes.containsKey((Object)parent)) continue;
                ready.put(n, entry.getValue());
            }
            LOGGER.fine(() -> "Ready to resume: " + ready);
            this.nodes.keySet().removeAll(ready.keySet());
            for (Map.Entry<FlowNode, Object> entry : ready.entrySet()) {
                n = entry.getKey();
                StepExecution exec = (StepExecution)entry.getValue();
                this.processing.add(n);
                Computer.threadPoolForRemoting.submit(() -> {
                    LOGGER.fine(() -> "About to resume " + n + " ~ " + exec);
                    try {
                        exec.onResume();
                    }
                    catch (Throwable x) {
                        exec.getContext().onFailure(x);
                    }
                    LOGGER.fine(() -> "Finished resuming " + n + " ~ " + exec);
                    ParallelResumer parallelResumer = this;
                    synchronized (parallelResumer) {
                        this.processing.remove((Object)n);
                        this.run();
                    }
                });
            }
        }
    }

    @Extension
    public static class ResumeStepExecutionListener
    extends FlowExecutionListener {
        @Override
        public void onResumed(final @NonNull FlowExecution e) {
            Futures.addCallback(e.getCurrentExecutions(false), (FutureCallback)new FutureCallback<List<StepExecution>>(){

                public void onSuccess(@NonNull List<StepExecution> result) {
                    if (e.isComplete()) {
                        return;
                    }
                    FlowExecutionList list = FlowExecutionList.get();
                    FlowExecutionOwner owner = e.getOwner();
                    if (!list.runningTasks.contains((Object)owner)) {
                        LOGGER.log(Level.WARNING, "Resuming {0}, which is missing from FlowExecutionList ({1}), so registering it now.", new Object[]{owner, list.runningTasks.getView()});
                        list.register(owner);
                    }
                    LOGGER.log(Level.FINE, "Will resume {0}", result);
                    new ParallelResumer(result, e::afterStepExecutionsResumed).run();
                }

                public void onFailure(@NonNull Throwable t) {
                    if (t instanceof CancellationException) {
                        LOGGER.log(Level.FINE, "Cancelled load of " + e, t);
                    } else {
                        LOGGER.log(Level.WARNING, "Failed to load " + e, t);
                    }
                    e.afterStepExecutionsResumed();
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    @Extension
    public static class StepExecutionIteratorImpl
    extends StepExecutionIterator {
        public ListenableFuture<?> apply(final Function<StepExecution, Void> f) {
            ArrayList<ListenableFuture<List<StepExecution>>> all = new ArrayList<ListenableFuture<List<StepExecution>>>();
            for (FlowExecution e : FlowExecutionList.get()) {
                ListenableFuture<List<StepExecution>> execs = e.getCurrentExecutions(false);
                all.add(execs);
                Futures.addCallback(execs, (FutureCallback)new FutureCallback<List<StepExecution>>(){

                    public void onSuccess(@NonNull List<StepExecution> result) {
                        for (StepExecution e : result) {
                            try {
                                f.apply((Object)e);
                            }
                            catch (RuntimeException x) {
                                LOGGER.log(Level.WARNING, null, x);
                            }
                        }
                    }

                    public void onFailure(@NonNull Throwable t) {
                        LOGGER.log(Level.WARNING, null, t);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
            return Futures.allAsList(all);
        }
    }

    @Extension
    public static class ItemListenerImpl
    extends ItemListener {
        public void onLoaded() {
            FlowExecutionList.get().resume();
        }
    }
}

