/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import hudson.CloseProofOutputStream;
import hudson.model.BuildListener;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.RemoteOutputStream;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Cleaner;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.log.DelayBufferedOutputStream;
import org.jenkinsci.plugins.workflow.log.GCFlushedOutputStream;
import org.jenkinsci.plugins.workflow.log.OutputStreamTaskListener;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

final class BufferedBuildListener
extends OutputStreamTaskListener.Default
implements BuildListener,
Closeable,
SerializableOnlyOverRemoting {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BufferedBuildListener.class.getName());
    private static final Cleaner cleaner = Cleaner.create((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), BufferedBuildListener.class.getName() + ".cleaner"));
    private final OutputStream out;
    private final transient Channel channel;
    private final transient Listener listener;

    BufferedBuildListener(OutputStream out) {
        this.out = out;
        if (out instanceof CloseableOutputStream) {
            this.channel = Channel.currentOrFail();
            this.listener = new Listener((CloseableOutputStream)out, this.channel);
            this.channel.addListener((Channel.Listener)this.listener);
            cleaner.register(this, this.listener);
        } else {
            this.channel = null;
            this.listener = null;
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        this.getLogger().close();
        if (this.listener != null) {
            this.channel.removeListener((Channel.Listener)this.listener);
        }
    }

    private Object writeReplace() {
        return new Replacement(this);
    }

    private static final class CloseableOutputStream
    extends FilterOutputStream {
        private Channel channel;
        private IOException cause;

        CloseableOutputStream(OutputStream delegate) {
            super(delegate);
        }

        void close(Channel channel, IOException cause) {
            this.channel = channel;
            this.cause = cause;
        }

        private void checkClosed() throws IOException {
            if (this.channel != null) {
                throw new ChannelClosedException(this.channel, (Throwable)this.cause);
            }
            LOGGER.finer("not closed yet");
        }

        @Override
        public void write(int b) throws IOException {
            this.checkClosed();
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkClosed();
            this.out.write(b, off, len);
        }

        public String toString() {
            return "CloseableOutputStream[" + this.out + "]";
        }
    }

    private static final class Replacement
    implements SerializableOnlyOverRemoting {
        private static final long serialVersionUID = 1L;
        private final RemoteOutputStream ros;
        private final DelayBufferedOutputStream.Tuning tuning = DelayBufferedOutputStream.Tuning.DEFAULT;

        Replacement(BufferedBuildListener cbl) {
            this.ros = new RemoteOutputStream((OutputStream)new CloseProofOutputStream(cbl.out));
        }

        private Object readResolve() {
            return new BufferedBuildListener(new CloseableOutputStream(new GCFlushedOutputStream(new DelayBufferedOutputStream((OutputStream)this.ros, this.tuning))));
        }
    }

    private static final class Listener
    extends Channel.Listener
    implements Runnable {
        private final CloseableOutputStream cos;
        private final Channel channel;

        Listener(CloseableOutputStream cos, Channel channel) {
            this.cos = cos;
            this.channel = channel;
        }

        public void onClosed(Channel channel, IOException cause) {
            LOGGER.fine(() -> "closing " + channel.getName());
            this.cos.close(channel, cause);
            channel.removeListener((Channel.Listener)this);
        }

        @Override
        public void run() {
            this.channel.removeListener((Channel.Listener)this);
        }
    }
}

