/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.util.BuildListenerAdapter;
import jenkins.util.JenkinsJVM;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.log.OutputStreamTaskListener;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

public abstract class TaskListenerDecorator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(TaskListenerDecorator.class.getName());

    @NonNull
    public abstract OutputStream decorate(@NonNull OutputStream var1) throws IOException, InterruptedException;

    @Nullable
    public static TaskListenerDecorator merge(@CheckForNull TaskListenerDecorator original, @CheckForNull TaskListenerDecorator subsequent) {
        if (original == null) {
            return subsequent;
        }
        if (subsequent == null) {
            return original;
        }
        return new MergedTaskListenerDecorator(original, subsequent);
    }

    @CheckForNull
    public static TaskListenerDecorator fromConsoleLogFilter(@CheckForNull ConsoleLogFilter filter) {
        if (filter == null) {
            return null;
        }
        if (filter instanceof Serializable) {
            return new ConsoleLogFilterAdapter(filter);
        }
        LOGGER.log(Level.WARNING, "{0} must implement Serializable to be used with Pipeline", filter.getClass());
        return null;
    }

    public static BuildListener apply(@NonNull TaskListener listener, @NonNull FlowExecutionOwner owner, @CheckForNull TaskListenerDecorator mainDecorator) {
        JenkinsJVM.checkJenkinsJVM();
        ExtensionList decoratorFactories = ExtensionList.lookup(Factory.class);
        List decorators = Stream.concat(decoratorFactories.stream().filter(f -> !f.isAppliedBeforeMainDecorator()).map(f -> f.of(owner)), Stream.concat(Stream.of(mainDecorator), decoratorFactories.stream().filter(f -> f.isAppliedBeforeMainDecorator()).map(f -> f.of(owner)))).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        if (decorators.isEmpty()) {
            return CloseableTaskListener.of(BuildListenerAdapter.wrap((TaskListener)listener), listener);
        }
        Collections.reverse(decorators);
        return CloseableTaskListener.of(new DecoratedTaskListener(listener, decorators), listener);
    }

    private static OutputStream decorateAll(OutputStream base, List<TaskListenerDecorator> decorators) {
        for (TaskListenerDecorator decorator : decorators) {
            try {
                base = decorator.decorate(base);
            }
            catch (Throwable x) {
                LOGGER.log(Level.WARNING, null, x);
                Functions.printStackTrace((Throwable)x, (PrintStream)new PrintStream(base, true, StandardCharsets.UTF_8));
            }
        }
        return base;
    }

    private static final class CloseableTaskListener
    implements BuildListener,
    AutoCloseable,
    OutputStreamTaskListener {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final TaskListener mainDelegate;
        @NonNull
        private final TaskListener closeDelegate;

        static BuildListener of(BuildListener mainDelegate, TaskListener closeDelegate) {
            if (closeDelegate instanceof AutoCloseable) {
                return new CloseableTaskListener((TaskListener)mainDelegate, closeDelegate);
            }
            return mainDelegate;
        }

        private CloseableTaskListener(@NonNull TaskListener mainDelegate, @NonNull TaskListener closeDelegate) {
            this.mainDelegate = mainDelegate;
            this.closeDelegate = closeDelegate;
            assert (closeDelegate instanceof AutoCloseable);
        }

        @Override
        @NonNull
        public OutputStream getOutputStream() {
            return OutputStreamTaskListener.getOutputStream(this.mainDelegate);
        }

        @NonNull
        public PrintStream getLogger() {
            return this.mainDelegate.getLogger();
        }

        @Override
        public void close() throws Exception {
            ((AutoCloseable)this.closeDelegate).close();
        }

        public String toString() {
            return "CloseableTaskListener[" + this.mainDelegate + " / " + this.closeDelegate + "]";
        }
    }

    private static final class DecoratedTaskListener
    extends OutputStreamTaskListener.Default
    implements BuildListener {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final TaskListener delegate;
        @NonNull
        private final List<TaskListenerDecorator> decorators;
        private transient OutputStream out;

        DecoratedTaskListener(@NonNull TaskListener delegate, @NonNull List<TaskListenerDecorator> decorators) {
            this.delegate = delegate;
            assert (!decorators.isEmpty());
            assert (!decorators.contains(null));
            this.decorators = decorators;
        }

        @Override
        @NonNull
        public OutputStream getOutputStream() {
            if (this.out == null) {
                this.out = TaskListenerDecorator.decorateAll(OutputStreamTaskListener.getOutputStream(this.delegate), this.decorators);
            }
            return this.out;
        }

        public String toString() {
            return "DecoratedTaskListener[" + this.delegate + this.decorators + "]";
        }
    }

    private static class ConsoleLogFilterAdapter
    extends TaskListenerDecorator {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Explicitly checking for serializability.")
        @NonNull
        private final ConsoleLogFilter filter;

        ConsoleLogFilterAdapter(@NonNull ConsoleLogFilter filter) {
            assert (filter instanceof Serializable);
            this.filter = filter;
        }

        @Override
        @NonNull
        public OutputStream decorate(@NonNull OutputStream logger) throws IOException, InterruptedException {
            return this.filter.decorateLogger((AbstractBuild)null, logger);
        }

        public String toString() {
            return "ConsoleLogFilter[" + this.filter + "]";
        }
    }

    private static class MergedTaskListenerDecorator
    extends TaskListenerDecorator {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final TaskListenerDecorator original;
        @NonNull
        private final TaskListenerDecorator subsequent;

        MergedTaskListenerDecorator(@NonNull TaskListenerDecorator original, @NonNull TaskListenerDecorator subsequent) {
            this.original = original;
            this.subsequent = subsequent;
        }

        @Override
        @NonNull
        public OutputStream decorate(@NonNull OutputStream logger) throws IOException, InterruptedException {
            return TaskListenerDecorator.decorateAll(logger, List.of(this.subsequent, this.original));
        }

        public String toString() {
            return "MergedTaskListenerDecorator[" + this.subsequent + ", " + this.original + "]";
        }
    }

    public static interface Factory
    extends ExtensionPoint {
        @CheckForNull
        public TaskListenerDecorator of(@NonNull FlowExecutionOwner var1);

        @Restricted(value={Beta.class})
        default public boolean isAppliedBeforeMainDecorator() {
            return false;
        }
    }
}

