/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameComparator;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProviderManager;
import com.cloudbees.plugins.credentials.CredentialsResolver;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.CredentialsUseListener;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.builds.CredentialsParameterBinder;
import com.cloudbees.plugins.credentials.builds.CredentialsParameterBinding;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.fingerprints.ItemCredentialsFingerprintFacet;
import com.cloudbees.plugins.credentials.fingerprints.NodeCredentialsFingerprintFacet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.DescriptorExtensionList;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Fingerprint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.security.SecurityRealm;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.FingerprintFacet;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class CredentialsProvider
extends Descriptor<CredentialsProvider>
implements ExtensionPoint,
Describable<CredentialsProvider>,
IconSpec {
    public static final CredentialsProvider NONE = new CredentialsProvider(){};
    public static final PermissionGroup GROUP = new PermissionGroup(CredentialsProvider.class, Messages._CredentialsProvider_PermissionGroupTitle());
    public static final Permission USE_OWN = new Permission(GROUP, "UseOwn", Messages._CredentialsProvider_UseOwnPermissionDescription(), Boolean.getBoolean("com.cloudbees.plugins.credentials.UseOwnPermission") ? Jenkins.ADMINISTER : Job.BUILD, Boolean.getBoolean("com.cloudbees.plugins.credentials.UseOwnPermission"), new PermissionScope[]{PermissionScope.ITEM});
    public static final Permission USE_ITEM = new Permission(GROUP, "UseItem", Messages._CredentialsProvider_UseItemPermissionDescription(), Job.CONFIGURE, Boolean.getBoolean("com.cloudbees.plugins.credentials.UseItemPermission"), new PermissionScope[]{PermissionScope.ITEM});
    private static final Logger LOGGER = Logger.getLogger(CredentialsProvider.class.getName());
    private static final PermissionScope[] SCOPES = new PermissionScope[]{PermissionScope.ITEM, PermissionScope.ITEM_GROUP, PermissionScope.JENKINS};
    public static final Permission CREATE = new Permission(GROUP, "Create", Messages._CredentialsProvider_CreatePermissionDescription(), Permission.CREATE, true, SCOPES);
    public static final Permission UPDATE = new Permission(GROUP, "Update", Messages._CredentialsProvider_UpdatePermissionDescription(), Permission.UPDATE, true, SCOPES);
    public static final Permission VIEW = new Permission(GROUP, "View", Messages._CredentialsProvider_ViewPermissionDescription(), Permission.READ, true, SCOPES);
    public static final Permission DELETE = new Permission(GROUP, "Delete", Messages._CredentialsProvider_DeletePermissionDescription(), Permission.DELETE, true, SCOPES);
    public static final Permission MANAGE_DOMAINS = new Permission(GROUP, "ManageDomains", Messages._CredentialsProvider_ManageDomainsPermissionDescription(), Permission.CONFIGURE, true, SCOPES);
    private static final String FINGERPRINT_ENABLED_NAME = CredentialsProvider.class.getSimpleName() + ".fingerprintEnabled";
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    static boolean FINGERPRINT_ENABLED = Boolean.parseBoolean(System.getProperty(FINGERPRINT_ENABLED_NAME, "true"));

    public CredentialsProvider() {
        super(Descriptor.self());
    }

    public static DescriptorExtensionList<Credentials, CredentialsDescriptor> allCredentialsDescriptors() {
        return Jenkins.get().getDescriptorList(Credentials.class);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type) {
        return CredentialsProvider.lookupCredentials(type, (Item)null, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, (ItemGroup)Jenkins.get(), authentication);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item) {
        return item == null ? CredentialsProvider.lookupCredentials(type, (ItemGroup)Jenkins.get(), ACL.SYSTEM) : CredentialsProvider.lookupCredentials(type, item, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentialsInItemGroup(type, itemGroup, authentication == null ? null : authentication.toSpring(), Collections.emptyList());
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentialsInItem(type, item, authentication == null ? null : authentication.toSpring(), Collections.emptyList());
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.lookupCredentialsInItemGroup(type, itemGroup, authentication == null ? null : authentication.toSpring(), Arrays.asList(domainRequirements == null ? new DomainRequirement[]{} : domainRequirements));
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentialsInItemGroup(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable org.springframework.security.core.Authentication authentication) {
        return CredentialsProvider.lookupCredentialsInItemGroup(type, itemGroup, authentication, List.of());
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements) {
        return CredentialsProvider.lookupCredentialsInItemGroup(type, itemGroup, authentication == null ? null : authentication.toSpring(), domainRequirements);
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentialsInItemGroup(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable org.springframework.security.core.Authentication authentication, @Nullable List<DomainRequirement> domainRequirements) {
        Objects.requireNonNull(type);
        Jenkins jenkins = Jenkins.get();
        itemGroup = itemGroup == null ? jenkins : itemGroup;
        authentication = authentication == null ? ACL.SYSTEM2 : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null) {
            LOGGER.log(Level.FINE, "Resolving legacy credentials of type {0} with resolver {1}", new Object[]{type, resolver});
            List<Credentials> originals = CredentialsProvider.lookupCredentialsInItemGroup(resolver.getFromClass(), itemGroup, authentication, domainRequirements);
            LOGGER.log(Level.FINE, "Original credentials for resolving: {0}", originals);
            return resolver.resolve(originals);
        }
        ArrayList<Credentials> result = new ArrayList<Credentials>();
        HashSet<String> ids = new HashSet<String>();
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            if (!provider.isEnabled(itemGroup) || !provider.isApplicable(type)) continue;
            try {
                for (Credentials c : provider.getCredentialsInItemGroup(type, itemGroup, authentication, domainRequirements)) {
                    if (c instanceof IdCredentials && !ids.add(((IdCredentials)c).getId())) continue;
                    result.add(c);
                }
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + provider + " likely due to missing optional dependency", e);
            }
        }
        return result;
    }

    @Deprecated
    public static <C extends IdCredentials> ListBoxModel listCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements, @Nullable CredentialsMatcher matcher) {
        return CredentialsProvider.listCredentialsInItemGroup(type, itemGroup, authentication == null ? null : authentication.toSpring(), domainRequirements, matcher);
    }

    public static <C extends IdCredentials> ListBoxModel listCredentialsInItemGroup(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable org.springframework.security.core.Authentication authentication, @Nullable List<DomainRequirement> domainRequirements, @Nullable CredentialsMatcher matcher) {
        Objects.requireNonNull(type);
        Jenkins jenkins = Jenkins.get();
        itemGroup = itemGroup == null ? jenkins : itemGroup;
        authentication = authentication == null ? ACL.SYSTEM2 : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        matcher = matcher == null ? CredentialsMatchers.always() : matcher;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null && IdCredentials.class.isAssignableFrom(resolver.getFromClass())) {
            LOGGER.log(Level.FINE, "Listing legacy credentials of type {0} identified by resolver {1}", new Object[]{type, resolver});
            return CredentialsProvider.listCredentialsInItemGroup(resolver.getFromClass(), itemGroup, authentication, domainRequirements, matcher);
        }
        ListBoxModel result = new ListBoxModel();
        HashSet<String> ids = new HashSet<String>();
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            if (!provider.isEnabled(itemGroup) || !provider.isApplicable(type)) continue;
            try {
                for (ListBoxModel.Option option : provider.getCredentialIdsInItemGroup(type, itemGroup, authentication, domainRequirements, matcher)) {
                    if (!ids.add(option.value)) continue;
                    result.add((Object)option);
                }
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + provider + " likely due to missing optional dependency", e);
            }
        }
        result.sort((Comparator)new ListBoxModelOptionComparator());
        return result;
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.lookupCredentialsInItem(type, item, authentication == null ? null : authentication.toSpring(), Arrays.asList(domainRequirements));
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentialsInItem(@NonNull Class<C> type, @Nullable Item item, @Nullable org.springframework.security.core.Authentication authentication) {
        return CredentialsProvider.lookupCredentialsInItem(type, item, authentication, List.of());
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements) {
        return CredentialsProvider.lookupCredentialsInItem(type, item, authentication == null ? null : authentication.toSpring(), domainRequirements);
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentialsInItem(@NonNull Class<C> type, @Nullable Item item, @Nullable org.springframework.security.core.Authentication authentication, @Nullable List<DomainRequirement> domainRequirements) {
        Objects.requireNonNull(type);
        if (item == null) {
            return CredentialsProvider.lookupCredentialsInItemGroup(type, (ItemGroup)Jenkins.get(), authentication, domainRequirements);
        }
        if (item instanceof ItemGroup) {
            return CredentialsProvider.lookupCredentialsInItemGroup(type, (ItemGroup)item, authentication, domainRequirements);
        }
        authentication = authentication == null ? ACL.SYSTEM2 : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null) {
            LOGGER.log(Level.FINE, "Resolving legacy credentials of type {0} with resolver {1}", new Object[]{type, resolver});
            List<Credentials> originals = CredentialsProvider.lookupCredentialsInItem(resolver.getFromClass(), item, authentication, domainRequirements);
            LOGGER.log(Level.FINE, "Original credentials for resolving: {0}", originals);
            return resolver.resolve(originals);
        }
        ArrayList<Credentials> result = new ArrayList<Credentials>();
        HashSet<String> ids = new HashSet<String>();
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            if (!provider.isEnabled(item) || !provider.isApplicable(type)) continue;
            try {
                for (Credentials c : provider.getCredentialsInItem(type, item, authentication, domainRequirements)) {
                    if (c instanceof IdCredentials && !ids.add(((IdCredentials)c).getId())) continue;
                    result.add(c);
                }
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + provider + " likely due to missing optional dependency", e);
            }
        }
        return result;
    }

    @Deprecated
    @NonNull
    public static <C extends IdCredentials> ListBoxModel listCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements, @Nullable CredentialsMatcher matcher) {
        return CredentialsProvider.listCredentialsInItem(type, item, authentication == null ? null : authentication.toSpring(), domainRequirements, matcher);
    }

    @NonNull
    public static <C extends IdCredentials> ListBoxModel listCredentialsInItem(@NonNull Class<C> type, @Nullable Item item, @Nullable org.springframework.security.core.Authentication authentication, @Nullable List<DomainRequirement> domainRequirements, @Nullable CredentialsMatcher matcher) {
        Objects.requireNonNull(type);
        if (item == null) {
            return CredentialsProvider.listCredentialsInItemGroup(type, (ItemGroup)Jenkins.get(), authentication, domainRequirements, matcher);
        }
        if (item instanceof ItemGroup) {
            return CredentialsProvider.listCredentialsInItemGroup(type, (ItemGroup)item, authentication, domainRequirements, matcher);
        }
        authentication = authentication == null ? ACL.SYSTEM2 : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null && IdCredentials.class.isAssignableFrom(resolver.getFromClass())) {
            LOGGER.log(Level.FINE, "Listing legacy credentials of type {0} identified by resolver {1}", new Object[]{type, resolver});
            return CredentialsProvider.listCredentialsInItem(resolver.getFromClass(), item, authentication, domainRequirements, matcher);
        }
        ListBoxModel result = new ListBoxModel();
        HashSet<String> ids = new HashSet<String>();
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            if (!provider.isEnabled(item) || !provider.isApplicable(type)) continue;
            try {
                for (ListBoxModel.Option option : provider.getCredentialIdsInItem(type, item, authentication, domainRequirements, matcher == null ? CredentialsMatchers.always() : matcher)) {
                    if (!ids.add(option.value)) continue;
                    result.add((Object)option);
                }
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + provider + " likely due to missing optional dependency", e);
            }
        }
        result.sort((Comparator)new ListBoxModelOptionComparator());
        return result;
    }

    @CheckForNull
    public static Set<CredentialsScope> lookupScopes(ModelObject object) {
        object = CredentialsDescriptor.unwrapContext(object);
        LinkedHashSet<CredentialsScope> result = null;
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            if (!provider.isEnabled(object)) continue;
            try {
                Set<CredentialsScope> scopes = provider.getScopes(object);
                if (scopes == null) continue;
                if (result == null) {
                    result = new LinkedHashSet<CredentialsScope>();
                }
                result.addAll(scopes);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return result;
    }

    public static boolean hasStores(ModelObject context) {
        for (CredentialsProvider p : CredentialsProvider.all()) {
            if (!p.isEnabled(context) || p.getStore(context) == null) continue;
            return true;
        }
        return false;
    }

    public static Iterable<CredentialsStore> lookupStores(final ModelObject context) {
        final ExtensionList<CredentialsProvider> providers = CredentialsProvider.all();
        return () -> new Iterator<CredentialsStore>(){
            private ModelObject current;
            private CredentialsStore next;
            private Iterator iterator;
            {
                this.current = context;
                this.iterator = providers.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (this.current != null) {
                    while (this.iterator.hasNext()) {
                        CredentialsProvider p = (CredentialsProvider)((Object)this.iterator.next());
                        if (!p.isEnabled(context)) continue;
                        this.next = p.getStore(this.current);
                        if (this.next == null) continue;
                        return true;
                    }
                    if (this.current instanceof Item) {
                        this.current = ((Item)this.current).getParent();
                        this.iterator = providers.iterator();
                        continue;
                    }
                    if (this.current instanceof User) {
                        org.springframework.security.core.Authentication a;
                        Jenkins jenkins = Jenkins.get();
                        if (jenkins.hasPermission(USE_ITEM) && this.current == User.current()) {
                            a = Jenkins.getAuthentication2();
                        } else {
                            try {
                                a = ((User)this.current).impersonate2();
                            }
                            catch (UsernameNotFoundException e) {
                                a = Jenkins.ANONYMOUS2;
                            }
                        }
                        if (this.current == User.current() && jenkins.getACL().hasPermission2(a, USE_ITEM)) {
                            this.current = jenkins;
                            this.iterator = providers.iterator();
                            continue;
                        }
                        this.current = null;
                        continue;
                    }
                    if (this.current instanceof Jenkins) {
                        this.current = null;
                        continue;
                    }
                    if (this.current instanceof ComputerSet) {
                        this.current = Jenkins.get();
                        this.iterator = providers.iterator();
                        continue;
                    }
                    if (this.current instanceof Computer) {
                        this.current = Jenkins.get();
                        this.iterator = providers.iterator();
                        continue;
                    }
                    if (this.current instanceof Node) {
                        this.current = Jenkins.get();
                        this.iterator = providers.iterator();
                        continue;
                    }
                    this.current = Jenkins.get();
                    this.iterator = providers.iterator();
                }
                return false;
            }

            @Override
            public CredentialsStore next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    CredentialsStore credentialsStore = this.next;
                    return credentialsStore;
                }
                finally {
                    this.next = null;
                }
            }
        };
    }

    public static <C extends Credentials> C snapshot(C credential) {
        return (C)CredentialsProvider.snapshot(Credentials.class, credential);
    }

    public static <C extends Credentials> C snapshot(Class<C> clazz, C credential) {
        Class bestType = null;
        CredentialsSnapshotTaker bestTaker = null;
        for (CredentialsSnapshotTaker taker : ExtensionList.lookup(CredentialsSnapshotTaker.class)) {
            if (!clazz.isAssignableFrom(taker.type()) || !taker.type().isInstance(credential) || bestTaker != null && !bestType.isAssignableFrom(taker.type())) continue;
            bestTaker = taker;
            bestType = taker.type();
        }
        if (bestTaker == null) {
            return credential;
        }
        return (C)((Credentials)clazz.cast(bestTaker.snapshot(credential)));
    }

    @NonNull
    static org.springframework.security.core.Authentication getDefaultAuthenticationOf2(Item item) {
        if (item instanceof Queue.Task) {
            return Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)item));
        }
        return ACL.SYSTEM2;
    }

    @CheckForNull
    public static <C extends IdCredentials> C findCredentialById(@NonNull String id, @NonNull Class<C> type, @NonNull Run<?, ?> run) {
        return CredentialsProvider.findCredentialById(id, type, run, List.of());
    }

    public static <C extends IdCredentials> C findCredentialById(@NonNull String id, @NonNull Class<C> type, @NonNull Run<?, ?> run, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.findCredentialById(id, type, run, Arrays.asList(domainRequirements));
    }

    @CheckForNull
    public static <C extends IdCredentials> C findCredentialById(@NonNull String id, @NonNull Class<C> type, @NonNull Run<?, ?> run, @Nullable List<DomainRequirement> domainRequirements) {
        org.springframework.security.core.Authentication inputAuth;
        User inputUser;
        Objects.requireNonNull(id);
        Objects.requireNonNull(type);
        Objects.requireNonNull(run);
        id = id.trim();
        boolean isParameter = false;
        boolean isDefaultValue = false;
        String inputUserId = null;
        String parameterName = id.startsWith("${") && id.endsWith("}") ? id.substring(2, id.length() - 1) : id;
        CredentialsParameterBinder binder = CredentialsParameterBinder.getOrCreate(run);
        CredentialsParameterBinding binding = binder.forParameterName(parameterName);
        if (binding != null) {
            isParameter = true;
            inputUserId = binding.getUserId();
            isDefaultValue = binding.isDefaultValue();
            id = Util.fixNull((String)binding.getCredentialsId());
        }
        if (!isParameter || isDefaultValue) {
            org.springframework.security.core.Authentication runAuth = CredentialsProvider.getDefaultAuthenticationOf2((Item)run.getParent());
            ArrayList<C> candidates = new ArrayList<C>(CredentialsProvider.lookupCredentialsInItem(type, (Item)run.getParent(), runAuth, domainRequirements));
            if (runAuth != ACL.SYSTEM2 && run.hasPermission2(runAuth, USE_ITEM)) {
                candidates.addAll(CredentialsProvider.lookupCredentialsInItem(type, (Item)run.getParent(), ACL.SYSTEM2, domainRequirements));
            }
            return (C)CredentialsProvider.contextualize(type, (IdCredentials)CredentialsMatchers.firstOrNull(candidates, CredentialsMatchers.withId(id)), run);
        }
        Map.Entry<User, Run<?, ?>> triggeredBy = CredentialsProvider.triggeredBy(run);
        org.springframework.security.core.Authentication a = triggeredBy == null ? Jenkins.ANONYMOUS2 : triggeredBy.getKey().impersonate2();
        ArrayList<C> candidates = new ArrayList<C>();
        if (triggeredBy != null && run == triggeredBy.getValue() && run.hasPermission2(a, USE_OWN)) {
            candidates.addAll(CredentialsProvider.lookupCredentialsInItem(type, (Item)run.getParent(), a, domainRequirements));
        }
        if (inputUserId != null && (inputUser = User.getById((String)inputUserId, (boolean)false)) != null && run.hasPermission2(inputAuth = inputUser.impersonate2(), USE_OWN)) {
            candidates.addAll(CredentialsProvider.lookupCredentialsInItem(type, (Item)run.getParent(), inputAuth, domainRequirements));
        }
        if (run.hasPermission2(a, USE_ITEM)) {
            org.springframework.security.core.Authentication runAuth = CredentialsProvider.getDefaultAuthenticationOf2((Item)run.getParent());
            candidates.addAll(CredentialsProvider.lookupCredentialsInItem(type, (Item)run.getParent(), runAuth, domainRequirements));
            if (runAuth != ACL.SYSTEM2 && run.hasPermission2(runAuth, USE_ITEM)) {
                candidates.addAll(CredentialsProvider.lookupCredentialsInItem(type, (Item)run.getParent(), ACL.SYSTEM2, domainRequirements));
            }
        }
        IdCredentials result = (IdCredentials)CredentialsMatchers.firstOrNull(candidates, CredentialsMatchers.withId(id));
        if (run.isLogUpdated()) {
            CredentialsProvider.track(run, result);
        }
        return (C)CredentialsProvider.contextualize(type, result, run);
    }

    @CheckForNull
    private static <C extends Credentials> C contextualize(@NonNull Class<C> type, @CheckForNull C credentials, @NonNull Run<?, ?> run) {
        if (credentials != null) {
            Credentials contextualized = credentials.forRun(run);
            if (type.isInstance(contextualized)) {
                return (C)((Credentials)type.cast(contextualized));
            }
            LOGGER.warning(() -> "Ignoring " + contextualized.getClass().getName() + " return value of " + credentials.getClass().getName() + ".forRun since it is not assignable to " + type.getName());
        }
        return credentials;
    }

    @CheckForNull
    private static Map.Entry<User, Run<?, ?>> triggeredBy(Run<?, ?> run) {
        Cause.UserIdCause cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
        if (cause != null) {
            User u = User.get((String)cause.getUserId(), (boolean)false, Collections.emptyMap());
            return u == null ? null : new AbstractMap.SimpleImmutableEntry<User, Run>(u, run);
        }
        Cause.UpstreamCause c = (Cause.UpstreamCause)run.getCause(Cause.UpstreamCause.class);
        Run run2 = run = c != null ? c.getUpstreamRun() : null;
        while (run != null) {
            cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
            if (cause != null) {
                User u = User.get((String)cause.getUserId(), (boolean)false, Collections.emptyMap());
                return u == null ? null : new AbstractMap.SimpleImmutableEntry<User, Run>(u, run);
            }
            c = (Cause.UpstreamCause)run.getCause(Cause.UpstreamCause.class);
            run = c != null ? c.getUpstreamRun() : null;
        }
        return null;
    }

    public static ExtensionList<CredentialsProvider> all() {
        return ExtensionList.lookup(CredentialsProvider.class);
    }

    public static List<CredentialsProvider> enabled() {
        return ExtensionList.lookup(CredentialsProvider.class).stream().filter(CredentialsProvider::isEnabled).collect(Collectors.toList());
    }

    public static List<CredentialsProvider> enabled(Object context) {
        return ExtensionList.lookup(CredentialsProvider.class).stream().filter(p -> p.isEnabled(context)).collect(Collectors.toList());
    }

    public Descriptor<CredentialsProvider> getDescriptor() {
        return this;
    }

    public final boolean isEnabled() {
        return CredentialsProviderManager.isEnabled(this);
    }

    public boolean isEnabled(Object context) {
        if (!this.isEnabled()) {
            return false;
        }
        for (DescriptorVisibilityFilter filter : DescriptorVisibilityFilter.all()) {
            if (filter.filter(context, (Descriptor)this)) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public String getDisplayName() {
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)((Object)((Object)this)).getClass().getSimpleName()), (char)' ');
    }

    public String getIconClassName() {
        return "symbol-credentials plugin-credentials";
    }

    public Set<CredentialsScope> getScopes(ModelObject object) {
        return null;
    }

    @CheckForNull
    public CredentialsStore getStore(@CheckForNull ModelObject object) {
        return null;
    }

    @Deprecated
    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        return this.getCredentialsInItemGroup(type, itemGroup, authentication == null ? null : authentication.toSpring(), List.of());
    }

    @Deprecated
    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentialsInItemGroup(type, itemGroup, authentication == null ? null : authentication.toSpring(), domainRequirements);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentialsInItemGroup(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable org.springframework.security.core.Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        if (Util.isOverridden(CredentialsProvider.class, ((Object)((Object)this)).getClass(), (String)"getCredentials", (Class[])new Class[]{Class.class, ItemGroup.class, Authentication.class, List.class})) {
            return this.getCredentials(type, itemGroup, authentication == null ? null : Authentication.fromSpring((org.springframework.security.core.Authentication)authentication), domainRequirements);
        }
        if (Util.isOverridden(CredentialsProvider.class, ((Object)((Object)this)).getClass(), (String)"getCredentials", (Class[])new Class[]{Class.class, ItemGroup.class, Authentication.class})) {
            return this.getCredentials(type, itemGroup, authentication == null ? null : Authentication.fromSpring((org.springframework.security.core.Authentication)authentication));
        }
        throw new AbstractMethodError("Implement getCredentialsInItemGroup from " + ((Object)((Object)this)).getClass());
    }

    @Deprecated
    @NonNull
    public <C extends IdCredentials> ListBoxModel getCredentialIds(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        return this.getCredentialIdsInItemGroup(type, itemGroup, authentication == null ? null : authentication.toSpring(), domainRequirements, matcher);
    }

    @NonNull
    public <C extends IdCredentials> ListBoxModel getCredentialIdsInItemGroup(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable org.springframework.security.core.Authentication authentication, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        return this.getCredentialsInItemGroup(type, itemGroup, authentication, domainRequirements).stream().filter(matcher::matches).sorted(new CredentialsNameComparator()).map(c -> new ListBoxModel.Option(CredentialsNameProvider.name(c), c.getId())).collect(Collectors.toCollection(ListBoxModel::new));
    }

    @Deprecated
    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication) {
        Objects.requireNonNull(item);
        return this.getCredentialsInItemFallback(type, item, authentication == null ? null : authentication.toSpring(), List.of());
    }

    @Deprecated
    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentialsInItemFallback(type, item, authentication == null ? null : authentication.toSpring(), domainRequirements);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentialsInItem(@NonNull Class<C> type, @NonNull Item item, @Nullable org.springframework.security.core.Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        if (Util.isOverridden(CredentialsProvider.class, ((Object)((Object)this)).getClass(), (String)"getCredentials", (Class[])new Class[]{Class.class, Item.class, Authentication.class, List.class})) {
            return this.getCredentials(type, item, authentication == null ? null : Authentication.fromSpring((org.springframework.security.core.Authentication)authentication), domainRequirements);
        }
        if (Util.isOverridden(CredentialsProvider.class, ((Object)((Object)this)).getClass(), (String)"getCredentials", (Class[])new Class[]{Class.class, Item.class, Authentication.class})) {
            return this.getCredentials(type, item, authentication == null ? null : Authentication.fromSpring((org.springframework.security.core.Authentication)authentication));
        }
        return this.getCredentialsInItemFallback(type, item, authentication, domainRequirements);
    }

    @NonNull
    private <C extends Credentials> List<C> getCredentialsInItemFallback(@NonNull Class<C> type, @NonNull Item item, @Nullable org.springframework.security.core.Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentialsInItemGroup(type, item instanceof ItemGroup ? (ItemGroup)item : item.getParent(), authentication, domainRequirements);
    }

    @Deprecated
    @NonNull
    public <C extends IdCredentials> ListBoxModel getCredentialIds(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        return this.getCredentialIdsInItem(type, item, authentication == null ? null : authentication.toSpring(), domainRequirements, matcher);
    }

    @NonNull
    public <C extends IdCredentials> ListBoxModel getCredentialIdsInItem(@NonNull Class<C> type, @NonNull Item item, @Nullable org.springframework.security.core.Authentication authentication, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        if (item instanceof ItemGroup) {
            return this.getCredentialIdsInItemGroup(type, (ItemGroup)item, authentication, domainRequirements, matcher);
        }
        return this.getCredentialsInItem(type, item, authentication, domainRequirements).stream().filter(matcher::matches).sorted(new CredentialsNameComparator()).map(c -> new ListBoxModel.Option(CredentialsNameProvider.name(c), c.getId())).collect(Collectors.toCollection(ListBoxModel::new));
    }

    public final boolean isApplicable(Class<? extends Credentials> clazz) {
        if (!this.isEnabled()) {
            return false;
        }
        for (CredentialsDescriptor d : ExtensionList.lookup(CredentialsDescriptor.class)) {
            if (!clazz.isAssignableFrom(d.clazz) || !this.isApplicable(d)) continue;
            return true;
        }
        return false;
    }

    public final boolean isApplicable(Descriptor<?> descriptor) {
        if (!this.isEnabled()) {
            return false;
        }
        if (descriptor instanceof CredentialsDescriptor && !((CredentialsDescriptor)descriptor).isApplicable(this)) {
            return false;
        }
        for (DescriptorVisibilityFilter filter : DescriptorVisibilityFilter.all()) {
            if (filter.filter((Object)this, descriptor)) continue;
            return false;
        }
        return this._isApplicable(descriptor);
    }

    protected boolean _isApplicable(Descriptor<?> descriptor) {
        return true;
    }

    public final List<CredentialsDescriptor> getCredentialsDescriptors() {
        return DescriptorVisibilityFilter.apply((Object)((Object)this), (Iterable)ExtensionList.lookup(CredentialsDescriptor.class)).stream().filter(this::_isApplicable).collect(Collectors.toList());
    }

    public final boolean hasCredentialsDescriptors() {
        ExtensionList filters = DescriptorVisibilityFilter.all();
        block0: for (CredentialsDescriptor d : ExtensionList.lookup(CredentialsDescriptor.class)) {
            for (DescriptorVisibilityFilter f : filters) {
                if (f.filter((Object)this, (Descriptor)d)) continue;
                continue block0;
            }
            if (!this._isApplicable(d)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public static Fingerprint getFingerprintOf(@NonNull Credentials c) throws IOException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            DigestOutputStream out = new DigestOutputStream(OutputStream.nullOutputStream(), md5);
            try {
                CredentialsStoreAction.FINGERPRINT_XML.toXML((Object)c, (Writer)new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            return (Fingerprint)Jenkins.get().getFingerprintMap().get(Util.toHexString((byte[])md5.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("JLS mandates MD5 as a supported digest algorithm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Fingerprint getOrCreateFingerprintOf(@NonNull Credentials c) throws IOException {
        String pseudoFilename = String.format("Credential id=%s name=%s", c instanceof IdCredentials ? ((IdCredentials)c).getId() : "unknown", CredentialsNameProvider.name(c));
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            DigestOutputStream out = new DigestOutputStream(OutputStream.nullOutputStream(), md5);
            try {
                CredentialsStoreAction.FINGERPRINT_XML.toXML((Object)c, (Writer)new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            return Jenkins.get().getFingerprintMap().getOrCreate(null, pseudoFilename, md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("JLS mandates MD5 as a supported digest algorithm");
        }
    }

    @CheckForNull
    public static <C extends Credentials> C track(@NonNull Run build, @CheckForNull C credentials) {
        if (credentials != null) {
            CredentialsProvider.trackAll(build, Collections.singletonList(credentials));
        }
        return credentials;
    }

    @SafeVarargs
    @NonNull
    public static <C extends Credentials> List<C> trackAll(@NonNull Run build, C ... credentials) {
        if (credentials != null) {
            return CredentialsProvider.trackAll(build, Arrays.asList(credentials));
        }
        return Collections.emptyList();
    }

    @NonNull
    public static <C extends Credentials> List<C> trackAll(@NonNull Run build, @NonNull List<C> credentials) {
        if (FINGERPRINT_ENABLED) {
            for (Credentials c : credentials) {
                if (c == null) continue;
                try {
                    CredentialsProvider.getOrCreateFingerprintOf(c).addFor(build);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINEST, "Could not track usage of " + c, e);
                }
            }
        } else {
            LOGGER.log(Level.FINEST, "TrackAll method (Run variant) called but fingerprints disabled by {0}", FINGERPRINT_ENABLED_NAME);
        }
        for (Credentials c : credentials) {
            CredentialsUseListener.fireUse(c, build);
        }
        return credentials;
    }

    @CheckForNull
    public static <C extends Credentials> C track(@NonNull Node node, @CheckForNull C credentials) {
        if (credentials != null) {
            CredentialsProvider.trackAll(node, Collections.singletonList(credentials));
        }
        return credentials;
    }

    @SafeVarargs
    @NonNull
    public static <C extends Credentials> List<C> trackAll(@NonNull Node node, C ... credentials) {
        if (credentials != null) {
            return CredentialsProvider.trackAll(node, Arrays.asList(credentials));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static <C extends Credentials> List<C> trackAll(@NonNull Node node, @NonNull List<C> credentials) {
        if (FINGERPRINT_ENABLED) {
            long timestamp = System.currentTimeMillis();
            String nodeName = node.getNodeName();
            HashSet<String> jenkinsNodeNames = new HashSet<String>();
            for (Node n : Jenkins.get().getNodes()) {
                jenkinsNodeNames.add(n.getNodeName());
            }
            for (Credentials c : credentials) {
                if (c == null) continue;
                try {
                    Fingerprint fingerprint = CredentialsProvider.getOrCreateFingerprintOf(c);
                    BulkChange change = new BulkChange((Saveable)fingerprint);
                    try {
                        Collection facets = fingerprint.getFacets();
                        long start = timestamp;
                        Iterator iterator = facets.iterator();
                        while (iterator.hasNext()) {
                            FingerprintFacet f = (FingerprintFacet)iterator.next();
                            if (!(f instanceof NodeCredentialsFingerprintFacet)) continue;
                            if (StringUtils.equals((String)nodeName, (String)((NodeCredentialsFingerprintFacet)f).getNodeName())) {
                                start = Math.min(start, f.getTimestamp());
                                iterator.remove();
                                continue;
                            }
                            if (jenkinsNodeNames.contains(((NodeCredentialsFingerprintFacet)f).getNodeName())) continue;
                            iterator.remove();
                        }
                        if (!jenkinsNodeNames.contains(node.getNodeName())) continue;
                        facets.add(new NodeCredentialsFingerprintFacet(node, fingerprint, start, timestamp));
                    }
                    finally {
                        change.commit();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINEST, "Could not track usage of " + c, e);
                }
            }
        } else {
            LOGGER.log(Level.FINEST, "TrackAll method (Node variant) called but fingerprints disabled by {0}", FINGERPRINT_ENABLED_NAME);
        }
        for (Credentials c : credentials) {
            CredentialsUseListener.fireUse(c, node);
        }
        return credentials;
    }

    @CheckForNull
    public static <C extends Credentials> C track(@NonNull Item item, @CheckForNull C credentials) {
        if (credentials != null) {
            CredentialsProvider.trackAll(item, Collections.singletonList(credentials));
        }
        return credentials;
    }

    @SafeVarargs
    @NonNull
    public static <C extends Credentials> List<C> trackAll(@NonNull Item item, C ... credentials) {
        if (credentials != null) {
            return CredentialsProvider.trackAll(item, Arrays.asList(credentials));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static <C extends Credentials> List<C> trackAll(@NonNull Item item, @NonNull List<C> credentials) {
        if (FINGERPRINT_ENABLED) {
            long timestamp = System.currentTimeMillis();
            String fullName = item.getFullName();
            for (Credentials c : credentials) {
                if (c == null) continue;
                try {
                    Fingerprint fingerprint = CredentialsProvider.getOrCreateFingerprintOf(c);
                    BulkChange change = new BulkChange((Saveable)fingerprint);
                    try {
                        Collection facets = fingerprint.getFacets();
                        long start = timestamp;
                        Iterator iterator = facets.iterator();
                        while (iterator.hasNext()) {
                            FingerprintFacet f = (FingerprintFacet)iterator.next();
                            if (!(f instanceof ItemCredentialsFingerprintFacet) || !StringUtils.equals((String)fullName, (String)((ItemCredentialsFingerprintFacet)f).getItemFullName())) continue;
                            start = Math.min(start, f.getTimestamp());
                            iterator.remove();
                        }
                        facets.add(new ItemCredentialsFingerprintFacet(item, fingerprint, start, timestamp));
                    }
                    finally {
                        change.commit();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINEST, "Could not track usage of " + c, e);
                }
            }
        } else {
            LOGGER.log(Level.FINEST, "TrackAll method (Item variant) called but fingerprints disabled by {0}", FINGERPRINT_ENABLED_NAME);
        }
        for (Credentials c : credentials) {
            CredentialsUseListener.fireUse(c, item);
        }
        return credentials;
    }

    @Restricted(value={DoNotUse.class})
    public static void saveAll() {
        LOGGER.entering(CredentialsProvider.class.getName(), "saveAll");
        try {
            Jenkins jenkins = Jenkins.get();
            jenkins.checkPermission(Jenkins.ADMINISTER);
            LOGGER.log(Level.INFO, "Forced save credentials stores: Requested by {0}", StringUtils.defaultIfBlank((String)Jenkins.getAuthentication2().getName(), (String)"anonymous"));
            Timer.get().execute(() -> {
                try {
                    ACLContext ignored = ACL.as2((org.springframework.security.core.Authentication)ACL.SYSTEM2);
                    try {
                        if (jenkins.getInitLevel().compareTo((Enum)InitMilestone.JOB_LOADED) < 0) {
                            LOGGER.log(Level.INFO, "Forced save credentials stores: Initialization has not completed");
                            while (jenkins.getInitLevel().compareTo((Enum)InitMilestone.JOB_LOADED) < 0) {
                                LOGGER.log(Level.INFO, "Forced save credentials stores: Sleeping for 1 second");
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    LOGGER.log(Level.WARNING, "Forced save credentials stores: Aborting due to interrupt", e);
                                    if (ignored != null) {
                                        ignored.close();
                                    }
                                    LOGGER.log(Level.INFO, "Forced save credentials stores: Completed");
                                    return;
                                }
                            }
                            LOGGER.log(Level.INFO, "Forced save credentials stores: Initialization has completed");
                        }
                        LOGGER.log(Level.INFO, "Forced save credentials stores: Processing Jenkins");
                        for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)jenkins)) {
                            try {
                                s.save();
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, "Forced save credentials stores: Could not save " + s, e);
                            }
                        }
                        LOGGER.log(Level.INFO, "Forced save credentials stores: Processing Items...");
                        int count = 0;
                        for (Item item : jenkins.getAllItems(Item.class)) {
                            if (++count % 100 == 0) {
                                LOGGER.log(Level.INFO, "Forced save credentials stores: Processing Items ({0} processed)", count);
                            }
                            for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)item)) {
                                if (item != s.getContext()) continue;
                                try {
                                    s.save();
                                }
                                catch (IOException e) {
                                    LOGGER.log(Level.WARNING, "Forced save credentials stores: Could not save " + s, e);
                                }
                            }
                        }
                        LOGGER.log(Level.INFO, "Forced save credentials stores: Processing Users...");
                        count = 0;
                        for (User user : User.getAll()) {
                            if (++count % 100 == 0) {
                                LOGGER.log(Level.INFO, "Forced save credentials stores: Processing Users ({0} processed)", count);
                            }
                            ACL.impersonate2((org.springframework.security.core.Authentication)new UsernamePasswordAuthenticationToken((Object)user.getId(), (Object)"", Set.of(SecurityRealm.AUTHENTICATED_AUTHORITY2)));
                            for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)user)) {
                                if (user != s.getContext()) continue;
                                try {
                                    s.save();
                                }
                                catch (IOException e) {
                                    LOGGER.log(Level.WARNING, "Forced save credentials stores: Could not save " + s, e);
                                }
                            }
                        }
                    }
                    finally {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2;
                                throwable2.addSuppressed(throwable);
                            }
                        }
                    }
                }
                finally {
                    LOGGER.log(Level.INFO, "Forced save credentials stores: Completed");
                }
            });
        }
        finally {
            LOGGER.exiting(CredentialsProvider.class.getName(), "saveAll");
        }
    }

    private static class ListBoxModelOptionComparator
    implements Comparator<ListBoxModel.Option> {
        private final Locale locale;
        private transient Collator collator;

        public ListBoxModelOptionComparator() {
            StaplerRequest req = Stapler.getCurrentRequest();
            this.locale = req != null ? req.getLocale() : Locale.getDefault();
            this.collator = Collator.getInstance(this.locale);
        }

        @Override
        public int compare(ListBoxModel.Option o1, ListBoxModel.Option o2) {
            return this.collator.compare(o1.name.toLowerCase(this.locale), o2.name.toLowerCase(this.locale));
        }
    }
}

