/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.Action;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import jenkins.scm.api.SCMRevisionAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class FlowCopier
implements ExtensionPoint {
    public abstract void copy(FlowExecutionOwner var1, FlowExecutionOwner var2) throws IOException, InterruptedException;

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class StandardActions
    extends ByRun {
        private static final Iterable<Class<? extends Action>> COPIED_ACTIONS = Collections.unmodifiableList(Arrays.asList(ParametersAction.class, SCMRevisionAction.class));

        @Override
        public void copy(Run<?, ?> original, Run<?, ?> copy, TaskListener listener) throws IOException, InterruptedException {
            for (Class<? extends Action> type : COPIED_ACTIONS) {
                Action a = original.getAction(type);
                if (a == null) continue;
                copy.replaceAction(a);
            }
        }
    }

    public static abstract class ByRun
    extends FlowCopier {
        public abstract void copy(Run<?, ?> var1, Run<?, ?> var2, TaskListener var3) throws IOException, InterruptedException;

        @Override
        public final void copy(FlowExecutionOwner original, FlowExecutionOwner copy) throws IOException, InterruptedException {
            Queue.Executable originalExec = original.getExecutable();
            Queue.Executable copyExec = copy.getExecutable();
            if (originalExec instanceof Run && copyExec instanceof Run) {
                this.copy((Run)originalExec, (Run)copyExec, copy.getListener());
            }
        }
    }
}

