/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.DirScanner;
import hudson.util.io.ArchiverFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jenkins.model.ArtifactManager;
import jenkins.model.Jenkins;
import jenkins.util.BuildListenerAdapter;
import jenkins.util.VirtualFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.workflow.flow.FlowCopier;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class StashManager {
    private static final String SUFFIX = ".tar.gz";

    @Deprecated
    public static void stash(@NonNull Run<?, ?> build, @NonNull String name, @NonNull FilePath workspace, @NonNull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes) throws IOException, InterruptedException {
        StashManager.stash(build, name, workspace, listener, includes, excludes, true, false);
    }

    @Deprecated
    public static void stash(@NonNull Run<?, ?> build, @NonNull String name, @NonNull FilePath workspace, @NonNull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes, boolean useDefaultExcludes) throws IOException, InterruptedException {
        StashManager.stash(build, name, workspace, listener, includes, excludes, useDefaultExcludes, false);
    }

    @Deprecated
    public static void stash(@NonNull Run<?, ?> build, @NonNull String name, @NonNull FilePath workspace, @NonNull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes, boolean useDefaultExcludes, boolean allowEmpty) throws IOException, InterruptedException {
        StashManager.stash(build, name, workspace, StashManager.launcherFor(workspace, listener), StashManager.envFor(build, workspace, listener), listener, includes, excludes, useDefaultExcludes, allowEmpty);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="fine if mkdirs returns false")
    public static void stash(@NonNull Run<?, ?> build, @NonNull String name, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull EnvVars env, @NonNull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes, boolean useDefaultExcludes, boolean allowEmpty) throws IOException, InterruptedException {
        Jenkins.checkGoodName((String)name);
        StashAwareArtifactManager saam = StashManager.stashAwareArtifactManager(build);
        if (saam != null) {
            saam.stash(name, workspace, launcher, env, listener, includes, excludes, useDefaultExcludes, allowEmpty);
            return;
        }
        File storage = StashManager.storage(build, name);
        storage.getParentFile().mkdirs();
        if (storage.isFile()) {
            listener.getLogger().println("Warning: overwriting stash \u2018" + name + "\u2019");
        }
        try (FileOutputStream os = new FileOutputStream(storage);){
            int count = workspace.archive(ArchiverFactory.TARGZ, (OutputStream)os, (DirScanner)new DirScanner.Glob(Util.fixEmpty((String)includes) == null ? "**" : includes, excludes, useDefaultExcludes));
            if (count == 0 && !allowEmpty) {
                throw new AbortException("No files included in stash \u2018" + name + "\u2019");
            }
            listener.getLogger().println("Stashed " + count + " file(s)");
        }
    }

    @Deprecated
    public static void unstash(@NonNull Run<?, ?> build, @NonNull String name, @NonNull FilePath workspace, @NonNull TaskListener listener) throws IOException, InterruptedException {
        StashManager.unstash(build, name, workspace, StashManager.launcherFor(workspace, listener), StashManager.envFor(build, workspace, listener), listener);
    }

    public static void unstash(@NonNull Run<?, ?> build, @NonNull String name, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull EnvVars env, @NonNull TaskListener listener) throws IOException, InterruptedException {
        Jenkins.checkGoodName((String)name);
        StashAwareArtifactManager saam = StashManager.stashAwareArtifactManager(build);
        if (saam != null) {
            saam.unstash(name, workspace, launcher, env, listener);
            return;
        }
        File storage = StashManager.storage(build, name);
        if (!storage.isFile()) {
            throw new AbortException("No such saved stash \u2018" + name + "\u2019");
        }
        new FilePath(storage).untar(workspace, FilePath.TarCompression.GZIP);
    }

    @Deprecated
    public static void clearAll(@NonNull Run<?, ?> build) throws IOException {
        try {
            StashManager.clearAll(build, TaskListener.NULL);
        }
        catch (InterruptedException x) {
            throw new IOException(x);
        }
    }

    public static void clearAll(@NonNull Run<?, ?> build, @NonNull TaskListener listener) throws IOException, InterruptedException {
        StashAwareArtifactManager saam = StashManager.stashAwareArtifactManager(build);
        if (saam != null) {
            saam.clearAllStashes(listener);
            return;
        }
        Util.deleteRecursive((File)StashManager.storage(build));
    }

    @Deprecated
    public static void maybeClearAll(@NonNull Run<?, ?> build) throws IOException {
        try {
            StashManager.maybeClearAll(build, TaskListener.NULL);
        }
        catch (InterruptedException x) {
            throw new IOException(x);
        }
    }

    public static void maybeClearAll(@NonNull Run<?, ?> build, @NonNull TaskListener listener) throws IOException, InterruptedException {
        for (StashBehavior behavior : ExtensionList.lookup(StashBehavior.class)) {
            if (behavior.shouldClearAll(build)) continue;
            return;
        }
        StashManager.clearAll(build, listener);
    }

    @Deprecated
    public static void copyAll(@NonNull Run<?, ?> from, @NonNull Run<?, ?> to) throws IOException {
        File fromStorage = StashManager.storage(from);
        if (!fromStorage.isDirectory()) {
            return;
        }
        FileUtils.copyDirectory((File)fromStorage, (File)StashManager.storage(to));
    }

    @Restricted(value={DoNotUse.class})
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="test code")
    public static Map<String, Map<String, String>> stashesOf(@NonNull Run<?, ?> build) throws IOException {
        TreeMap<String, Map<String, String>> result = new TreeMap<String, Map<String, String>>();
        File[] kids = StashManager.storage(build).listFiles();
        if (kids != null) {
            for (File kid : kids) {
                String n = kid.getName();
                if (!n.endsWith(SUFFIX)) continue;
                TreeMap<String, String> unpacked = new TreeMap<String, String>();
                result.put(n.substring(0, n.length() - SUFFIX.length()), unpacked);
                try (FileInputStream is = new FileInputStream(kid);){
                    ArchiveEntry archiveEntry;
                    InputStream wrapped = FilePath.TarCompression.GZIP.extract((InputStream)is);
                    TarArchiveInputStream archiveStream = new TarArchiveInputStream(wrapped);
                    while ((archiveEntry = archiveStream.getNextEntry()) != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)archiveStream, (OutputStream)baos);
                        unpacked.put(archiveEntry.getName(), baos.toString());
                    }
                }
            }
        }
        return result;
    }

    @NonNull
    private static File storage(@NonNull Run<?, ?> build) throws IOException {
        assert (StashManager.stashAwareArtifactManager(build) == null);
        return new File(build.getRootDir(), "stashes");
    }

    @NonNull
    private static File storage(@NonNull Run<?, ?> build, @NonNull String name) throws IOException {
        File dir = StashManager.storage(build);
        File f = new File(dir, name + SUFFIX);
        if (!f.getParentFile().equals(dir)) {
            throw new IllegalArgumentException();
        }
        return f;
    }

    private StashManager() {
    }

    @CheckForNull
    private static StashAwareArtifactManager stashAwareArtifactManager(@NonNull Run<?, ?> build) throws IOException {
        ArtifactManager am = build.pickArtifactManager();
        return am instanceof StashAwareArtifactManager ? (StashAwareArtifactManager)am : null;
    }

    @Deprecated
    @NonNull
    private static Launcher launcherFor(@NonNull FilePath workspace, @NonNull TaskListener listener) {
        Computer c = workspace.toComputer();
        if (c != null) {
            Node n = c.getNode();
            if (n != null) {
                return n.createLauncher(listener);
            }
            listener.error(c.getDisplayName() + " seems to be offline");
            return new Launcher.LocalLauncher(listener);
        }
        listener.error(workspace + " seems to be offline");
        return new Launcher.LocalLauncher(listener);
    }

    @Deprecated
    @NonNull
    private static EnvVars envFor(@NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull TaskListener listener) throws IOException, InterruptedException {
        Computer c = workspace.toComputer();
        if (c != null) {
            EnvVars e = c.getEnvironment();
            e.putAll((Map)c.buildEnvironment(listener));
            e.putAll((Map)build.getEnvironment(listener));
            return e;
        }
        listener.error(workspace + " seems to be offline");
        return new EnvVars();
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class CopyStashesAndArtifacts
    extends FlowCopier.ByRun {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copy(Run<?, ?> original, Run<?, ?> copy, TaskListener listener) throws IOException, InterruptedException {
            StashAwareArtifactManager saam = StashManager.stashAwareArtifactManager(original);
            if (saam != null) {
                saam.copyAllArtifactsAndStashes(copy, listener);
                return;
            }
            VirtualFile srcroot = original.getArtifactManager().root();
            FilePath dstDir = this.createTmpDir();
            try {
                HashMap<String, String> files = new HashMap<String, String>();
                for (String path : srcroot.list("**/*", null, false)) {
                    files.put(path, path);
                    InputStream in = srcroot.child(path).open();
                    try {
                        dstDir.child(path).copyFrom(in);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                if (!files.isEmpty()) {
                    listener.getLogger().println("Copying " + files.size() + " artifact(s) from " + original.getDisplayName());
                    copy.getArtifactManager().archive(dstDir, (Launcher)new Launcher.LocalLauncher(listener), (BuildListener)new BuildListenerAdapter(listener), files);
                }
            }
            finally {
                dstDir.deleteRecursive();
            }
            StashManager.copyAll(original, copy);
        }

        private FilePath createTmpDir() throws IOException {
            File dir = File.createTempFile("artifact", "copy");
            if (!dir.delete() || !dir.mkdirs()) {
                throw new IOException("Failed to create temporary directory " + dir.getPath());
            }
            return new FilePath(dir);
        }
    }

    public static interface StashAwareArtifactManager {
        public void stash(@NonNull String var1, @NonNull FilePath var2, @NonNull Launcher var3, @NonNull EnvVars var4, @NonNull TaskListener var5, @CheckForNull String var6, @CheckForNull String var7, boolean var8, boolean var9) throws IOException, InterruptedException;

        public void unstash(@NonNull String var1, @NonNull FilePath var2, @NonNull Launcher var3, @NonNull EnvVars var4, @NonNull TaskListener var5) throws IOException, InterruptedException;

        public void clearAllStashes(@NonNull TaskListener var1) throws IOException, InterruptedException;

        public void copyAllArtifactsAndStashes(@NonNull Run<?, ?> var1, @NonNull TaskListener var2) throws IOException, InterruptedException;
    }

    public static abstract class StashBehavior
    implements ExtensionPoint {
        public boolean shouldClearAll(@NonNull Run<?, ?> build) {
            return true;
        }
    }
}

