/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.Filterator;
import org.jenkinsci.plugins.workflow.graphanalysis.FilteratorImpl;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowNodeVisitor;

@NotThreadSafe
public abstract class AbstractFlowScanner
implements Iterable<FlowNode>,
Filterator<FlowNode> {
    protected FlowNode myCurrent;
    protected FlowNode myNext;
    protected Collection<FlowNode> myBlackList = Collections.emptySet();
    protected static final int MAX_LIST_CHECK_SIZE = 5;

    @NonNull
    protected Collection<FlowNode> convertToFastCheckable(@CheckForNull Collection<FlowNode> nodeCollection) {
        if (nodeCollection == null || nodeCollection.size() == 0) {
            return Collections.emptySet();
        }
        if (nodeCollection.size() == 1) {
            return Collections.singleton(nodeCollection.iterator().next());
        }
        if (nodeCollection instanceof HashSet) {
            return nodeCollection;
        }
        return nodeCollection.size() > 5 ? new HashSet(nodeCollection) : nodeCollection;
    }

    public boolean setup(@CheckForNull Collection<FlowNode> heads, @CheckForNull Collection<FlowNode> blackList) {
        if (heads == null || heads.size() == 0) {
            return false;
        }
        Collection<FlowNode> fastEndNodes = this.convertToFastCheckable(blackList);
        LinkedHashSet<FlowNode> filteredHeads = new LinkedHashSet<FlowNode>(heads);
        filteredHeads.removeAll(fastEndNodes);
        if (filteredHeads.size() == 0) {
            return false;
        }
        this.reset();
        this.myBlackList = fastEndNodes;
        this.setHeads(filteredHeads);
        return true;
    }

    public boolean setup(@CheckForNull Collection<FlowNode> heads) {
        if (heads == null) {
            return false;
        }
        return this.setup(heads, Collections.emptySet());
    }

    public boolean setup(@CheckForNull FlowNode head, @CheckForNull Collection<FlowNode> blackList) {
        if (head == null) {
            return false;
        }
        return this.setup(Collections.singleton(head), blackList);
    }

    public boolean setup(@CheckForNull FlowNode head) {
        if (head == null) {
            return false;
        }
        return this.setup(Collections.singleton(head), Collections.emptySet());
    }

    protected abstract void reset();

    protected abstract void setHeads(@NonNull Collection<FlowNode> var1);

    @CheckForNull
    protected abstract FlowNode next(@NonNull FlowNode var1, @NonNull Collection<FlowNode> var2);

    @Override
    public boolean hasNext() {
        return this.myNext != null;
    }

    @Override
    public FlowNode next() {
        if (this.myNext == null) {
            throw new NoSuchElementException();
        }
        this.myCurrent = this.myNext;
        this.myNext = this.next(this.myCurrent, this.myBlackList);
        return this.myCurrent;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("FlowGraphs are immutable, so FlowScanners can't remove nodes");
    }

    @Override
    @NonNull
    public Iterator<FlowNode> iterator() {
        return this;
    }

    @Override
    @NonNull
    public Filterator<FlowNode> filter(@NonNull Predicate<FlowNode> filterCondition) {
        return new FilteratorImpl<FlowNode>(this, filterCondition);
    }

    @CheckForNull
    public FlowNode findFirstMatch(@CheckForNull Collection<FlowNode> heads, @CheckForNull Collection<FlowNode> blackListNodes, Predicate<FlowNode> matchCondition) {
        if (!this.setup(heads, blackListNodes)) {
            return null;
        }
        for (FlowNode f : this) {
            if (!matchCondition.apply((Object)f)) continue;
            return f;
        }
        return null;
    }

    @CheckForNull
    public FlowNode findFirstMatch(@CheckForNull Collection<FlowNode> heads, @NonNull Predicate<FlowNode> matchPredicate) {
        return this.findFirstMatch(heads, null, matchPredicate);
    }

    @CheckForNull
    public FlowNode findFirstMatch(@CheckForNull FlowNode head, @NonNull Predicate<FlowNode> matchPredicate) {
        return this.findFirstMatch(Collections.singleton(head), null, matchPredicate);
    }

    @CheckForNull
    public FlowNode findFirstMatch(@CheckForNull FlowExecution exec, @NonNull Predicate<FlowNode> matchPredicate) {
        if (exec != null && exec.getCurrentHeads() != null && !exec.getCurrentHeads().isEmpty()) {
            return this.findFirstMatch(exec.getCurrentHeads(), null, matchPredicate);
        }
        return null;
    }

    @NonNull
    public List<FlowNode> filteredNodes(@CheckForNull Collection<FlowNode> heads, @CheckForNull Collection<FlowNode> blackList, Predicate<FlowNode> matchCondition) {
        if (!this.setup(heads, blackList)) {
            return Collections.emptyList();
        }
        ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
        for (FlowNode f : this) {
            if (!matchCondition.apply((Object)f)) continue;
            nodes.add(f);
        }
        return nodes;
    }

    @NonNull
    public List<FlowNode> allNodes(@CheckForNull Collection<FlowNode> heads) {
        if (!this.setup(heads)) {
            return Collections.emptyList();
        }
        ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
        for (FlowNode f : this) {
            nodes.add(f);
        }
        return nodes;
    }

    @NonNull
    public List<FlowNode> allNodes(@CheckForNull FlowExecution exec) {
        return exec == null ? Collections.emptyList() : this.allNodes(exec.getCurrentHeads());
    }

    @NonNull
    public List<FlowNode> filteredNodes(@CheckForNull Collection<FlowNode> heads, @NonNull Predicate<FlowNode> matchPredicate) {
        return this.filteredNodes(heads, null, matchPredicate);
    }

    @NonNull
    public List<FlowNode> filteredNodes(@CheckForNull FlowNode head, @NonNull Predicate<FlowNode> matchPredicate) {
        return this.filteredNodes(Collections.singleton(head), null, matchPredicate);
    }

    @NonNull
    public List<FlowNode> filteredNodes(@CheckForNull FlowExecution exec, @NonNull Predicate<FlowNode> matchPredicate) {
        if (exec == null) {
            return Collections.emptyList();
        }
        return this.filteredNodes(exec.getCurrentHeads(), null, matchPredicate);
    }

    public void visitAll(@CheckForNull Collection<FlowNode> heads, @CheckForNull Collection<FlowNode> blackList, @NonNull FlowNodeVisitor visitor) {
        FlowNode f;
        boolean canContinue;
        if (!this.setup(heads, blackList)) {
            return;
        }
        Iterator<FlowNode> iterator = this.iterator();
        while (iterator.hasNext() && (canContinue = visitor.visit(f = iterator.next()))) {
        }
    }

    public void visitAll(@CheckForNull Collection<FlowNode> heads, @NonNull FlowNodeVisitor visitor) {
        this.visitAll(heads, null, visitor);
    }
}

