/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.CloseProofOutputStream;
import hudson.model.BuildListener;
import hudson.remoting.RemoteOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.jenkinsci.plugins.workflow.log.DelayBufferedOutputStream;
import org.jenkinsci.plugins.workflow.log.GCFlushedOutputStream;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

final class BufferedBuildListener
implements BuildListener,
Closeable,
SerializableOnlyOverRemoting {
    private final OutputStream out;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="using Replacement anyway, fields here are irrelevant")
    private final PrintStream ps;

    BufferedBuildListener(OutputStream out) throws IOException {
        this.out = out;
        this.ps = new PrintStream(out, false, "UTF-8");
    }

    @NonNull
    public PrintStream getLogger() {
        return this.ps;
    }

    @Override
    public void close() throws IOException {
        this.ps.close();
    }

    private Object writeReplace() {
        return new Replacement(this);
    }

    private static final class Replacement
    implements SerializableOnlyOverRemoting {
        private static final long serialVersionUID = 1L;
        private final RemoteOutputStream ros;
        private final DelayBufferedOutputStream.Tuning tuning = DelayBufferedOutputStream.Tuning.DEFAULT;

        Replacement(BufferedBuildListener cbl) {
            this.ros = new RemoteOutputStream((OutputStream)new CloseProofOutputStream(cbl.out));
        }

        private Object readResolve() throws IOException {
            return new BufferedBuildListener(new GCFlushedOutputStream(new DelayBufferedOutputStream((OutputStream)this.ros, this.tuning)));
        }
    }
}

