/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.trilead;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.transport.RemoteSession;

public class TrileadSession
implements RemoteSession {
    protected final Connection con;

    public TrileadSession(Connection con) {
        this.con = con;
    }

    public Process exec(String commandName, int timeout) throws IOException {
        return new ProcessImpl(this.con, commandName, timeout);
    }

    public void disconnect() {
        this.con.close();
    }

    private static class ProcessImpl
    extends Process {
        private final int timeout;
        private final Session s;

        public ProcessImpl(Connection con, String commandName, int timeout) throws IOException {
            this.timeout = timeout;
            this.s = con.openSession();
            this.s.execCommand(commandName);
        }

        @Override
        public OutputStream getOutputStream() {
            return this.s.getStdin();
        }

        @Override
        public InputStream getInputStream() {
            return this.s.getStdout();
        }

        @Override
        public InputStream getErrorStream() {
            return this.s.getStderr();
        }

        @Override
        public int waitFor() throws InterruptedException {
            int r = this.s.waitForCondition(32, (long)this.timeout * 1000L);
            if ((r & 0x20) != 0) {
                return this.exitValue();
            }
            throw new InterruptedException("Timed out: " + r);
        }

        @Override
        public int exitValue() {
            Integer i = this.s.getExitStatus();
            if (i == null) {
                throw new IllegalThreadStateException();
            }
            return i;
        }

        @Override
        public void destroy() {
            this.s.close();
        }
    }
}

