/*
 * Decompiled with CFR 0.152.
 */
package hudson.search;

import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.search.SearchItem;
import hudson.search.SearchableModelObject;

public class SuggestedItem {
    private final SuggestedItem parent;
    public final SearchItem item;
    private String path;

    public SuggestedItem(SearchItem top) {
        this(null, top);
    }

    public SuggestedItem(SuggestedItem parent, SearchItem item) {
        this.parent = parent;
        this.item = item;
    }

    public String getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.parent == null) {
            this.path = this.item.getSearchName();
            return this.path;
        }
        StringBuilder buf = new StringBuilder();
        this.getPath(buf);
        this.path = buf.toString();
        return this.path;
    }

    private void getPath(StringBuilder buf) {
        if (this.parent == null) {
            buf.append(this.item.getSearchName());
        } else {
            this.parent.getPath(buf);
            buf.append(" \u00bb ").append(this.item.getSearchName());
        }
    }

    public String getUrl() {
        StringBuilder buf = new StringBuilder();
        this.getUrl(buf);
        return buf.toString();
    }

    private static SuggestedItem build(SearchableModelObject searchContext, Item top) {
        ItemGroup<? extends Item> parent = top.getParent();
        if (parent instanceof Item) {
            Item parentItem = (Item)((Object)parent);
            return new SuggestedItem(SuggestedItem.build(searchContext, parentItem), top);
        }
        return new SuggestedItem(top);
    }

    public static SuggestedItem build(SearchableModelObject searchContext, SearchItem si) {
        if (si instanceof Item) {
            return SuggestedItem.build(searchContext, (Item)si);
        }
        return new SuggestedItem(si);
    }

    private void getUrl(StringBuilder buf) {
        String f;
        if (this.parent != null) {
            this.parent.getUrl(buf);
        }
        if ((f = this.item.getSearchUrl()).startsWith("/")) {
            buf.setLength(0);
            buf.append(f);
        } else {
            if (buf.isEmpty() || buf.charAt(buf.length() - 1) != '/') {
                buf.append('/');
            }
            buf.append(f);
        }
    }
}

