/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.RestrictedSince;
import hudson.util.Secret;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="2.236")
public class Protector {
    private static final String ALGORITHM_MODE = "AES/CBC/PKCS5Padding";
    private static final String ALGORITHM = "AES";
    private static final String MAGIC = ":::MAGIC";
    private static final int IV_BYTES = 16;
    private static final SecretKey KEY;
    private static final SecureRandom SR;

    public static String protect(String secret) {
        try {
            byte[] iv = new byte[16];
            SR.nextBytes(iv);
            Cipher cipher = Secret.getCipher(ALGORITHM_MODE);
            cipher.init(1, (Key)KEY, new IvParameterSpec(iv));
            byte[] encrypted = cipher.doFinal((secret + MAGIC).getBytes(StandardCharsets.UTF_8));
            byte[] result = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, result, 0, iv.length);
            System.arraycopy(encrypted, 0, result, iv.length, encrypted.length);
            return new String(Base64.getEncoder().encode(result), StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException e) {
            throw new Error(e);
        }
    }

    public static String unprotect(String data) {
        if (data == null) {
            return null;
        }
        try {
            byte[] value = Base64.getDecoder().decode(data.getBytes(StandardCharsets.UTF_8));
            byte[] iv = Arrays.copyOfRange(value, 0, 16);
            byte[] encrypted = Arrays.copyOfRange(value, 16, value.length);
            Cipher cipher = Secret.getCipher(ALGORITHM_MODE);
            cipher.init(2, (Key)KEY, new IvParameterSpec(iv));
            String plainText = new String(cipher.doFinal(encrypted), StandardCharsets.UTF_8);
            if (plainText.endsWith(MAGIC)) {
                return plainText.substring(0, plainText.length() - MAGIC.length());
            }
            return null;
        }
        catch (RuntimeException | GeneralSecurityException e) {
            return null;
        }
    }

    static {
        SR = new SecureRandom();
        try {
            KeyGenerator instance = KeyGenerator.getInstance(ALGORITHM);
            KEY = instance.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }
}

