/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Util;
import hudson.util.Secret;
import hudson.util.TextFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import jenkins.model.Jenkins;
import jenkins.security.ConfidentialKey;
import jenkins.security.ConfidentialStore;
import jenkins.util.SystemProperties;

public class DefaultConfidentialStore
extends ConfidentialStore {
    static final String MASTER_KEY_FILE_SYSTEM_PROPERTY = DefaultConfidentialStore.class.getName() + ".file";
    static final String MASTER_KEY_READONLY_SYSTEM_PROPERTY_NAME = DefaultConfidentialStore.class.getName() + ".readOnly";
    private final SecureRandom sr = new SecureRandom();
    private final File rootDir;
    private final SecretKey masterKey;
    private static final byte[] MAGIC = "::::MAGIC::::".getBytes(StandardCharsets.US_ASCII);

    @NonNull
    private static File getMasterKeyFile(File rootDir) {
        String jenkinsMasterKey = SystemProperties.getString(MASTER_KEY_FILE_SYSTEM_PROPERTY);
        if (jenkinsMasterKey != null) {
            return new File(jenkinsMasterKey);
        }
        return new File(rootDir, "master.key");
    }

    public DefaultConfidentialStore() throws IOException, InterruptedException {
        this(new File(Jenkins.get().getRootDir(), "secrets"));
    }

    public DefaultConfidentialStore(File rootDir) throws IOException, InterruptedException {
        this(rootDir, DefaultConfidentialStore.getMasterKeyFile(rootDir));
    }

    protected DefaultConfidentialStore(File rootDir, File keyFile) throws IOException, InterruptedException {
        TextFile masterSecret;
        this.rootDir = rootDir;
        if (rootDir.mkdirs()) {
            new FilePath(rootDir).chmod(448);
        }
        if (!(masterSecret = new TextFile(keyFile)).exists()) {
            if (SystemProperties.getBoolean(MASTER_KEY_READONLY_SYSTEM_PROPERTY_NAME)) {
                throw new IOException(String.valueOf(masterSecret) + " does not exist and system property " + MASTER_KEY_READONLY_SYSTEM_PROPERTY_NAME + " is set. You must provide a valid master key file.");
            }
            masterSecret.write(Util.toHexString(this.randomBytes(128)));
        }
        this.masterKey = Util.toAes128Key(masterSecret.readTrim());
    }

    @Override
    protected void store(ConfidentialKey key, byte[] payload) throws IOException {
        try {
            Cipher sym = Secret.getCipher("AES");
            sym.init(1, this.masterKey);
            try (OutputStream fos = Files.newOutputStream(this.getFileFor(key).toPath(), new OpenOption[0]);
                 CipherOutputStream cos = new CipherOutputStream(fos, sym);){
                cos.write(payload);
                cos.write(MAGIC);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to persist the key: " + key.getId(), e);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] load(ConfidentialKey key) throws IOException {
        try {
            File f = this.getFileFor(key);
            if (!f.exists()) {
                return null;
            }
            Cipher sym = Secret.getCipher("AES");
            sym.init(2, this.masterKey);
            try (InputStream fis = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                byte[] byArray;
                try (CipherInputStream cis = new CipherInputStream(fis, sym);){
                    byte[] bytes = cis.readAllBytes();
                    byArray = this.verifyMagic(bytes);
                }
                return byArray;
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to load the key: " + key.getId(), e);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
        catch (IOException x) {
            if (x.getCause() instanceof BadPaddingException) {
                return null;
            }
            throw x;
        }
    }

    private byte[] verifyMagic(byte[] payload) {
        int payloadLen = payload.length - MAGIC.length;
        if (payloadLen < 0) {
            return null;
        }
        for (int i = 0; i < MAGIC.length; ++i) {
            if (payload[payloadLen + i] == MAGIC[i]) continue;
            return null;
        }
        byte[] truncated = new byte[payloadLen];
        System.arraycopy(payload, 0, truncated, 0, truncated.length);
        return truncated;
    }

    private File getFileFor(ConfidentialKey key) {
        return new File(this.rootDir, key.getId());
    }

    @Override
    SecureRandom secureRandom() {
        return this.sr;
    }

    @Override
    public byte[] randomBytes(int size) {
        byte[] random = new byte[size];
        this.sr.nextBytes(random);
        return random;
    }
}

