/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;

class RewindableFileOutputStream
extends OutputStream {
    protected final File out;
    private boolean closed;
    private boolean initialAppend;
    private OutputStream current;

    public RewindableFileOutputStream(File out) {
        this(out, false);
    }

    public RewindableFileOutputStream(File out, boolean initialAppend) {
        this.out = out;
        this.initialAppend = initialAppend;
    }

    private synchronized OutputStream current() throws IOException {
        if (this.current == null) {
            if (!this.closed) {
                FileUtils.forceMkdir((File)this.out.getParentFile());
                try {
                    this.current = new FileOutputStream(this.out, this.initialAppend);
                    this.initialAppend = false;
                }
                catch (FileNotFoundException e) {
                    throw new IOException("Failed to open " + String.valueOf(this.out), e);
                }
            } else {
                throw new IOException(this.out.getName() + " stream is closed");
            }
        }
        return this.current;
    }

    @Override
    public void write(int b) throws IOException {
        this.current().write(b);
    }

    @Override
    public void write(@NonNull byte[] b) throws IOException {
        this.current().write(b);
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        this.current().write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.current().flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.closeCurrent();
        this.closed = true;
    }

    public synchronized void rewind() throws IOException {
        this.closeCurrent();
    }

    private void closeCurrent() throws IOException {
        if (this.current != null) {
            this.current.close();
            this.current = null;
        }
    }
}

